/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.client.listener;

import com.xforceplus.apollo.client.service.ZySpService;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.core.common.configuration.JanusConfig;
import com.xforceplus.core.common.domain.JanusRequest;
import com.xforceplus.core.common.domain.JsonResult;
import com.xforceplus.core.common.domain.SealedRecMessage;
import com.xforceplus.core.common.domain.XReceiveMsgType;
import com.xforceplus.core.common.utils.XNettyClientUtils;
import com.xforceplus.core.handle.BaseReceiveMsgServiceHandle;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@XReceiveMsgType(value="remoteOrderQueryRequest")
public class RemoteOrderQueryHandleService
extends BaseReceiveMsgServiceHandle {
    private static final Logger log = LoggerFactory.getLogger(RemoteOrderQueryHandleService.class);
    @Autowired
    private ZySpService zySpService;
    @Autowired
    private JanusConfig janusConfig;
    @Autowired
    private XNettyClientUtils nettyClientUtils;

    public JsonResult process(SealedRecMessage sealedRecMessage) {
        Object obj = sealedRecMessage.getPayload().getObj();
        Map payloadMap = (Map)JacksonUtil.getInstance().fromJson((String)obj, Map.class);
        String sessionId = (String)payloadMap.get("sessionId");
        String orderNo = (String)payloadMap.get("orderNo");
        HashMap<String, String> others = new HashMap<String, String>();
        JanusRequest janusRequest = this.zySpService.orderQuery(orderNo);
        others.put("sessionId", sessionId);
        others.put("noAppkey", "true");
        others.put("customerNo", this.janusConfig.getTcp().getCustomerNo());
        janusRequest.setOthers(others);
        janusRequest.setPayLoadId(orderNo);
        janusRequest.setQueueNames("settlementUpload");
        this.nettyClientUtils.sendMsg(janusRequest);
        return JsonResult.ok();
    }
}

