/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.client.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.apollo.client.CompanyCallback;
import com.xforceplus.apollo.client.axis.invoice.InvoicesSynergyInput;
import com.xforceplus.apollo.client.axis.invoice.InvoicesSynergyOutput;
import com.xforceplus.apollo.client.axis.invoice.Pitems;
import com.xforceplus.apollo.client.axis.invoice.SalesBillInvoicePushManager;
import com.xforceplus.apollo.client.axis.invoice.SalesBillInvoicePushManagerServiceLocator;
import com.xforceplus.apollo.client.utils.CommonTools;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.core.common.domain.JsonResult;
import com.xforceplus.core.common.domain.SealedRecMessage;
import com.xforceplus.core.common.domain.XReceiveMsgType;
import com.xforceplus.core.handle.BaseReceiveMsgServiceHandle;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XReceiveMsgType(value="salesBillInvoicePush")
public class SalesBillInvoicePushThread
extends BaseReceiveMsgServiceHandle {
    private static final Logger log = LoggerFactory.getLogger(SalesBillInvoicePushThread.class);

    public JsonResult process(SealedRecMessage sealedRecMessage) {
        try {
            String groupFlag = (String)sealedRecMessage.getHeader().getOthers().get("groupFlag");
            String json = sealedRecMessage.getPayload().getObj().toString();
            log.info("###\u4e1a\u52a1\u5355\u5f00\u5177\u534f\u540c\u7ed3\u679c###:" + json);
            JSONObject jsonObject = JSON.parseObject((String)json);
            JSONObject sellerInvoiceMain = jsonObject.getJSONObject("sellerInvoiceMain");
            JSONArray salesBillObjList = jsonObject.getJSONArray("salesBillObjList");
            InvoicesSynergyInput invoicesSynergyInput = new InvoicesSynergyInput();
            invoicesSynergyInput.setInvoiceType(sellerInvoiceMain.getString("invoiceType").toUpperCase());
            String invoiceNo = sellerInvoiceMain.getString("invoiceNo");
            invoicesSynergyInput.setInvoiceNo(invoiceNo);
            String invoiceCode = sellerInvoiceMain.getString("invoiceCode");
            invoicesSynergyInput.setInvoiceCode(invoiceCode);
            invoicesSynergyInput.setTaxRate(sellerInvoiceMain.getBigDecimal("taxRate"));
            invoicesSynergyInput.setAmountWithoutTax(sellerInvoiceMain.getBigDecimal("amountWithoutTax"));
            invoicesSynergyInput.setTaxAmount(sellerInvoiceMain.getBigDecimal("taxAmount"));
            invoicesSynergyInput.setAmountWithTax(sellerInvoiceMain.getBigDecimal("amountWithTax"));
            invoicesSynergyInput.setPaperDrewDate(sellerInvoiceMain.getString("paperDrewDate"));
            invoicesSynergyInput.setRemark(CommonTools.getStr((Object)sellerInvoiceMain.get((Object)"remark")));
            invoicesSynergyInput.setCashierName(CommonTools.getStr((Object)sellerInvoiceMain.get((Object)"cashierName")));
            invoicesSynergyInput.setCheckerName(CommonTools.getStr((Object)sellerInvoiceMain.get((Object)"checkerName")));
            invoicesSynergyInput.setInvoicerName(CommonTools.getStr((Object)sellerInvoiceMain.get((Object)"invoicerName")));
            String status = sellerInvoiceMain.getString("status");
            invoicesSynergyInput.setStatus(status);
            invoicesSynergyInput.setOriginInvoiceNo(CommonTools.getStr((Object)sellerInvoiceMain.get((Object)"originInvoiceNo")));
            invoicesSynergyInput.setOriginInvoiceCode(CommonTools.getStr((Object)sellerInvoiceMain.get((Object)"originInvoiceCode")));
            invoicesSynergyInput.setRedNotificationNo(CommonTools.getStr((Object)sellerInvoiceMain.get((Object)"redNotificationNo")));
            invoicesSynergyInput.setUniqueNo(invoiceNo + "-" + invoiceCode + "-" + status);
            String pdfUrl = (String)sealedRecMessage.getHeader().getOthers().get("pdfUrl");
            invoicesSynergyInput.setPdfUrl(pdfUrl);
            String systemOry = "";
            Pitems[] pitemsList = new Pitems[salesBillObjList.size()];
            for (int i = 0; i < salesBillObjList.size(); ++i) {
                JSONObject pitemsJson = salesBillObjList.getJSONObject(i);
                Pitems pitems = new Pitems();
                pitems.setAlreadyMakeAmount(pitemsJson.getBigDecimal("alreadyMakeAmount"));
                String salesBillNo = pitemsJson.getString("salesBillNo");
                pitems.setSalesBillNo(salesBillNo.substring(salesBillNo.indexOf("-") + 1));
                pitems.setUnitPrice(pitemsJson.getBigDecimal("unitPrice"));
                pitems.setAmountWithoutTaxBill(pitemsJson.getBigDecimal("amountWithoutTax"));
                pitems.setQuantity(pitemsJson.getBigDecimal("quantity"));
                pitems.setGoodsTaxNo(pitemsJson.getString("goodsTaxNo"));
                pitems.setQuantityUnit(CommonTools.getStr((Object)pitemsJson.get((Object)"quantityUnit")));
                pitems.setTaxRateBill(pitemsJson.getBigDecimal("taxRate"));
                pitems.setTaxAmountBill(pitemsJson.getBigDecimal("taxAmount"));
                pitems.setAmountWithTaxBill(pitemsJson.getBigDecimal("amountWithTax"));
                pitems.setItemName(pitemsJson.getString("itemName"));
                pitems.setAlreadyMakeAmountWithoutTax(pitemsJson.getBigDecimal("alreadyMakeAmountWithoutTax").setScale(2, 4));
                pitems.setAlreadyMakeTaxAmount(pitemsJson.getBigDecimal("alreadyMakeTaxAmount").setScale(2, 4));
                pitemsList[i] = pitems;
                if (i != 0) continue;
                systemOry = salesBillNo.substring(0, salesBillNo.indexOf("-"));
            }
            invoicesSynergyInput.setItems(pitemsList);
            log.info("\u4e1a\u52a1\u5355\u7ed9\u5ba2\u6237\u7684\u6570\u636e:" + JacksonUtil.getInstance().toJson((Object)invoicesSynergyInput));
            URL url = null;
            if ("SY".equals(systemOry)) {
                url = new URL(CompanyCallback.sySalesBillInvoicePushManager);
            } else if ("ZG".equals(systemOry)) {
                url = new URL(CompanyCallback.zgSalesBillInvoicePushManager);
            }
            SalesBillInvoicePushManagerServiceLocator salesBillResultManagerService = new SalesBillInvoicePushManagerServiceLocator();
            SalesBillInvoicePushManager salesBillInvoicePushManagerPort = salesBillResultManagerService.getSalesBillInvoicePushManagerPort(url);
            InvoicesSynergyOutput invoicesSynergyOutput = salesBillInvoicePushManagerPort.salesBillInvoicePush(invoicesSynergyInput);
            log.info("\u4e1a\u52a1\u5355\u5ba2\u6237\u53cd\u9988:" + JacksonUtil.getInstance().toJson((Object)invoicesSynergyOutput));
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5f00\u7968\u534f\u540c\u9519\u8bef\u65e5\u5fd7", (Throwable)e);
        }
        return JsonResult.ok();
    }
}

