/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.client.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.apollo.client.CompanyCallback;
import com.xforceplus.apollo.client.CompanyConfig;
import com.xforceplus.apollo.client.axis.Pd58Z6001Input;
import com.xforceplus.apollo.client.axis.Pd58Z6001Output;
import com.xforceplus.apollo.client.axis.SalesBillResultManager;
import com.xforceplus.apollo.client.axis.SalesBillResultManagerServiceLocator;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.core.common.domain.JsonResult;
import com.xforceplus.core.common.domain.SealedRecMessage;
import com.xforceplus.core.common.domain.XReceiveMsgType;
import com.xforceplus.core.handle.BaseReceiveMsgServiceHandle;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XReceiveMsgType(value="SalesBillIOperationAction")
public class SalesBillOperationActionThread
extends BaseReceiveMsgServiceHandle {
    private static final Logger log = LoggerFactory.getLogger(SalesBillOperationActionThread.class);

    public JsonResult process(SealedRecMessage sealedRecMessage) {
        try {
            String groupFlag = (String)sealedRecMessage.getHeader().getOthers().get("groupFlag");
            if (CompanyConfig.GROUPFLAG.equals(groupFlag)) {
                String json = sealedRecMessage.getPayload().getObj().toString();
                log.info("\u4e1a\u52a1\u5355\u4f5c\u5e9f\u6216\u5220\u9664\u7ed3\u679c:" + json);
                JSONObject jsonObject = JSON.parseObject((String)json);
                JSONObject salesBillIVoidOrDelete = jsonObject.getJSONObject("salesBillIVoidOrDelete");
                String salesBillNo = salesBillIVoidOrDelete.getString("salesBillNo");
                String systemOry = salesBillNo.substring(0, salesBillNo.indexOf("-"));
                URL url = null;
                if ("SY".equals(systemOry)) {
                    url = new URL(CompanyCallback.syInvoiceService);
                } else if ("ZG".equals(systemOry)) {
                    url = new URL(CompanyCallback.zgInvoiceService);
                }
                SalesBillResultManagerServiceLocator salesBillResultManagerService = new SalesBillResultManagerServiceLocator();
                SalesBillResultManager salesBillResultManagerPort = salesBillResultManagerService.getSalesBillResultManagerPort(url);
                Pd58Z6001Input pd58Z6001Input = new Pd58Z6001Input();
                pd58Z6001Input.setSalesBillNo(salesBillNo.substring(salesBillNo.indexOf("-") + 1));
                pd58Z6001Input.setStatus(salesBillIVoidOrDelete.getString("code"));
                pd58Z6001Input.setResult("1");
                pd58Z6001Input.setHandleMsg(salesBillIVoidOrDelete.getString("message"));
                Pd58Z6001Output pd58Z6001Output = salesBillResultManagerPort.salesBillResult(pd58Z6001Input);
                log.info("\u4e1a\u52a1\u5355\u5ba2\u6237\u53cd\u9988:" + JacksonUtil.getInstance().toJson((Object)pd58Z6001Output));
            }
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5f00\u7968\u53cd\u9988\u9519\u8bef\u65e5\u5fd7", (Throwable)e);
        }
        return JsonResult.ok();
    }
}

