/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.client.listener;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.apollo.client.CompanyCallback;
import com.xforceplus.apollo.client.CompanyConfig;
import com.xforceplus.apollo.client.axis.Pd58Z6001Input;
import com.xforceplus.apollo.client.axis.Pd58Z6001Output;
import com.xforceplus.apollo.client.axis.SalesBillResultManager;
import com.xforceplus.apollo.client.axis.SalesBillResultManagerServiceLocator;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.core.common.domain.JsonResult;
import com.xforceplus.core.common.domain.SealedRecMessage;
import com.xforceplus.core.common.domain.XReceiveMsgType;
import com.xforceplus.core.handle.BaseReceiveMsgServiceHandle;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XReceiveMsgType(value="salesBillResult")
public class SalesBillResultThread
extends BaseReceiveMsgServiceHandle {
    private static final Logger log = LoggerFactory.getLogger(SalesBillResultThread.class);

    public JsonResult process(SealedRecMessage sealedRecMessage) {
        try {
            String groupFlag = (String)sealedRecMessage.getHeader().getOthers().get("groupFlag");
            if (CompanyConfig.GROUPFLAG.equals(groupFlag)) {
                String json = sealedRecMessage.getPayload().getObj().toString();
                log.info("\u4e1a\u52a1\u5355\u53cd\u9988\uff1a{}", (Object)json);
                JSONObject jsonObject = JSON.parseObject((String)json);
                JSONObject salesBillResult = jsonObject.getJSONObject("salesBillResult");
                JSONObject responseMsg = salesBillResult.getJSONArray("responseMsg").getJSONObject(0);
                String salesBillNo = responseMsg.getString("salesBillNo");
                String systemOry = salesBillNo.substring(0, salesBillNo.indexOf("-"));
                URL url = null;
                if ("SY".equals(systemOry)) {
                    url = new URL(CompanyCallback.syInvoiceService);
                } else if ("ZG".equals(systemOry)) {
                    url = new URL(CompanyCallback.zgInvoiceService);
                }
                log.info("\u4e1a\u52a1\u5355\u53cd\u9988\u5730\u5740:" + url);
                SalesBillResultManagerServiceLocator salesBillResultManagerService = new SalesBillResultManagerServiceLocator();
                SalesBillResultManager salesBillResultManagerPort = salesBillResultManagerService.getSalesBillResultManagerPort(url);
                Pd58Z6001Input pd58Z6001Input = new Pd58Z6001Input();
                pd58Z6001Input.setSalesBillNo(salesBillNo.substring(salesBillNo.indexOf("-") + 1));
                pd58Z6001Input.setStatus(salesBillResult.getString("status"));
                pd58Z6001Input.setResult(salesBillResult.getString("result"));
                pd58Z6001Input.setHandleMsg(responseMsg.getString("handleMsg"));
                Pd58Z6001Output pd58Z6001Output = salesBillResultManagerPort.salesBillResult(pd58Z6001Input);
                log.info("\u4e1a\u52a1\u5355\u5ba2\u6237\u53cd\u9988:" + JacksonUtil.getInstance().toJson((Object)pd58Z6001Output));
            } else {
                log.error("###\u4e1a\u52a1\u5355\u4e0a\u4f20\u53cd\u9988\u4e0b\u53d1 \u5206\u7ec4\u6807\u8bb0\u4e0d\u6b63\u786e###groupFlag:{}", (Object)groupFlag);
            }
        }
        catch (Exception e) {
            log.error("\u534f\u540c\u9519\u8bef\u65e5\u5fd7:{}", (Throwable)e);
        }
        return JsonResult.ok();
    }
}

