/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.client.listener;

import com.alibaba.fastjson.JSON;
import com.xforceplus.apollo.client.CompanyConfig;
import com.xforceplus.apollo.client.bean.SellerInvoice;
import com.xforceplus.apollo.client.service.ZySpService;
import com.xforceplus.apollo.client.utils.CommonTools;
import com.xforceplus.apollo.client.utils.JsonFloatValueProcessor;
import com.xforceplus.apollo.core.domain.sellerinvoice.SellerInvoiceDetails;
import com.xforceplus.core.common.domain.JsonResult;
import com.xforceplus.core.common.domain.SealedRecMessage;
import com.xforceplus.core.common.domain.XReceiveMsgType;
import com.xforceplus.core.handle.BaseReceiveMsgServiceHandle;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@XReceiveMsgType(value="sellerInvoicePush")
public class SellerInvoicePushListener
extends BaseReceiveMsgServiceHandle {
    private static final Logger log = LoggerFactory.getLogger(SellerInvoicePushListener.class);
    @Autowired
    private ZySpService zySpService;

    public JsonResult process(SealedRecMessage sealedRecMessage) {
        try {
            String str = sealedRecMessage.getPayload().getObj().toString();
            log.info("\u9500\u9879\u534f\u540c\u6570\u636e:{}", (Object)str);
            String result = "";
            String systemOrig = (String)sealedRecMessage.getHeader().getOthers().get("systemOrig");
            if ("TOC".equalsIgnoreCase(systemOrig)) {
                JsonResult jsonResult = this.tocInvoicePush(sealedRecMessage);
                return jsonResult;
            }
            result = this.callSettlementFeedback(str);
            log.info("\u9500\u9879\u534f\u540c\u5ba2\u6237\u53cd\u9988\u6570\u636e:{}", (Object)result);
            return JsonResult.ok((String)result);
        }
        catch (Exception e) {
            log.error("\u9500\u9879\u534f\u540c\u9519\u8bef\u65e5\u5fd7:{}", (Throwable)e);
            return JsonResult.error((String)e.getMessage());
        }
    }

    private JsonResult tocInvoicePush(SealedRecMessage sealedRecMessage) {
        String str = sealedRecMessage.getPayload().getObj().toString();
        SellerInvoice sellerInvoice = (SellerInvoice)JSON.parseObject((String)str, SellerInvoice.class);
        List sellerInvoiceDetailsList = sellerInvoice.getSellerInvoiceDetails();
        if (sellerInvoiceDetailsList == null || sellerInvoiceDetailsList.size() < 1) {
            return JsonResult.error((String)"\u6570\u636e\u4e3a\u7a7a\u6216\u89e3\u6790\u5931\u8d25");
        }
        String orderNo = sellerInvoiceDetailsList.stream().findFirst().map(SellerInvoiceDetails::getOrderNo).orElse("");
        if (StringUtils.isBlank((CharSequence)orderNo)) {
            return JsonResult.error((String)"\u672a\u89e3\u6790\u5230\u8ba2\u5355\u53f7\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        if ("".equalsIgnoreCase(orderNo)) {
            // empty if block
        }
        JsonResult jsonResult = this.zySpService.invoicePush(sellerInvoice);
        return jsonResult;
    }

    private String callSettlementFeedback(String str) throws Exception {
        String result = "";
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.registerJsonValueProcessor(Float.class, (JsonValueProcessor)new JsonFloatValueProcessor());
        Map map = CommonTools.writeJsonToMap((String)str);
        Map sellerInvoiceMain = (Map)map.get("sellerInvoiceMain");
        String settlementNo = sellerInvoiceMain.get("settlementNo").toString();
        log.warn("\u7ed3\u7b97\u5355 \u5355\u53f7:{}", (Object)settlementNo);
        if (settlementNo.indexOf("-") > -1) {
            String system = settlementNo.substring(0, settlementNo.indexOf("-"));
            if ("SL".equalsIgnoreCase(system)) {
                sellerInvoiceMain.put("averageTaxRate", CommonTools.getStr(sellerInvoiceMain.get("taxRate")));
                sellerInvoiceMain.put("settlementNo", settlementNo.substring(settlementNo.indexOf("-") + 1));
                map.put("sellerInvoiceMain", sellerInvoiceMain);
                String jsonStr = CommonTools.writeMapToJson((Map)map);
                log.warn("\u9500\u9879\u534f\u540c\u4e0b\u53d1\u6570\u636e:{}", (Object)jsonStr);
                Service service = new Service();
                String url = CompanyConfig.SL_CUSTOMER_INVOICE_SERVICES + "/myws/InvoiceService.asmx?wsdl";
                String namespace = "http://www.mysoft.com.cn/FPGL/";
                String actionUri = "http://www.mysoft.com.cn/FPGL/SellerInvoicePush";
                String op = "SellerInvoicePush";
                Call call = (Call)service.createCall();
                call.setTargetEndpointAddress(new URL(url));
                call.setUseSOAPAction(true);
                call.setSOAPActionURI(actionUri);
                call.setOperationName(new QName(namespace, op));
                call.addParameter(new QName(namespace, "strInvoiceJson"), javax.xml.rpc.encoding.XMLType.XSD_STRING, ParameterMode.IN);
                call.setReturnType(XMLType.XSD_STRING);
                Object[] params = new Object[]{jsonStr};
                result = (String)call.invoke(params);
            } else {
                result = "\u4e1a\u52a1\u5355\u5f00\u7968\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528\uff01\uff01\uff01";
            }
        } else {
            result = "\u4e1a\u52a1\u5355\u5f00\u7968\u6570\u636e\uff0c\u65e0\u6cd5\u8c03\u7528\uff01\uff01\uff01";
        }
        return result;
    }
}

