/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.client.listener;

import com.xforceplus.apollo.client.CompanyConfig;
import com.xforceplus.core.common.domain.JsonResult;
import com.xforceplus.core.common.domain.SealedRecMessage;
import com.xforceplus.core.common.domain.XReceiveMsgType;
import com.xforceplus.core.handle.BaseReceiveMsgServiceHandle;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import net.sf.json.JSONObject;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XReceiveMsgType(value="settlementActionResult")
public class SettlementActionResultListener
extends BaseReceiveMsgServiceHandle {
    private static final Logger log = LoggerFactory.getLogger(SettlementActionResultListener.class);

    public JsonResult process(SealedRecMessage sealedRecMessage) {
        try {
            String result = "";
            String str = sealedRecMessage.getPayload().getObj().toString();
            log.info("\u7ed3\u7b97\u5355\u5e73\u53f0\u53cd\u9988\u6570\u636e:{}", (Object)str);
            result = this.callSettlementFeedback(str);
            log.info("\u5e73\u53f0\u5ba2\u6237\u53cd\u9988\u6570\u636e:{}", (Object)result);
        }
        catch (Exception e) {
            log.error("\u7ed3\u7b97\u5355\u53cd\u9988\u9519\u8bef\u65e5\u5fd7:{}", (Throwable)e);
        }
        return JsonResult.ok();
    }

    private String callSettlementFeedback(String str) throws Exception {
        JSONObject jsonObject = JSONObject.fromObject((Object)str);
        String settlementNo = jsonObject.get("settlementNo").toString();
        jsonObject.put((Object)"settlementNo", (Object)settlementNo.substring(settlementNo.indexOf("-") + 1));
        jsonObject.put((Object)"settlementResult", (Object)jsonObject);
        Service service = new Service();
        String url = CompanyConfig.SL_CUSTOMER_INVOICE_SERVICES + "/myws/InvoiceService.asmx?wsdl";
        String namespace = "http://www.mysoft.com.cn/FPGL/";
        String actionUri = "http://www.mysoft.com.cn/FPGL/SettlementResult";
        String op = "SettlementResult";
        Call call = (Call)service.createCall();
        call.setTargetEndpointAddress(new URL(url));
        call.setUseSOAPAction(true);
        call.setSOAPActionURI(actionUri);
        call.setOperationName(new QName(namespace, op));
        call.addParameter(new QName(namespace, "strSettlementJson"), javax.xml.rpc.encoding.XMLType.XSD_STRING, ParameterMode.IN);
        call.setReturnType(XMLType.XSD_STRING);
        Object[] params = new Object[]{jsonObject.toString()};
        String result = (String)call.invoke(params);
        return result;
    }
}

