/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.client.listener;

import com.alibaba.fastjson.JSON;
import com.xforceplus.apollo.client.CompanyConfig;
import com.xforceplus.apollo.client.bean.SettlementResult;
import com.xforceplus.apollo.client.service.ZySpService;
import com.xforceplus.apollo.client.utils.CommonTools;
import com.xforceplus.core.common.domain.JsonResult;
import com.xforceplus.core.common.domain.SealedRecMessage;
import com.xforceplus.core.common.domain.XReceiveMsgType;
import com.xforceplus.core.handle.BaseReceiveMsgServiceHandle;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import net.sf.json.JSONObject;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@XReceiveMsgType(value="settlementResult")
public class SettlementResultListener
extends BaseReceiveMsgServiceHandle {
    private static final Logger log = LoggerFactory.getLogger(SettlementResultListener.class);
    @Autowired
    private ZySpService zySpService;

    public JsonResult process(SealedRecMessage sealedRecMessage) {
        try {
            String result = "";
            String str = sealedRecMessage.getPayload().getObj().toString();
            log.info("\u7ed3\u7b97\u5355\u53cd\u9988\u6570\u636e:{}", (Object)str);
            String systemOrig = (String)sealedRecMessage.getHeader().getOthers().get("systemOrig");
            if ("TOC".equalsIgnoreCase(systemOrig)) {
                JsonResult jsonResult = this.tocSettlementResult(sealedRecMessage);
                return jsonResult;
            }
            JSONObject jsonObject = JSONObject.fromObject((Object)str);
            JSONObject settlementResult = jsonObject.getJSONObject("settlementResult");
            if (settlementResult.toString().indexOf(":upload") != -1) {
                String status = CommonTools.getStr((Object)settlementResult.get("status"));
                if (!"1".equals(status)) {
                    JSONObject json = new JSONObject();
                    json.put((Object)"settlementResult", (Object)settlementResult);
                    result = this.callSettlementFeedback(json.toString());
                }
                log.info("\u5ba2\u6237\u53cd\u9988\u6570\u636e:{}", (Object)result);
            } else {
                JSONObject json = new JSONObject();
                json.put((Object)"settlementResult", (Object)settlementResult);
                result = this.callSettlementFeedback(json.toString());
                log.info("\u5ba2\u6237\u53cd\u9988\u6570\u636e:{}", (Object)result);
            }
        }
        catch (Exception e) {
            log.error("\u7ed3\u7b97\u5355\u53cd\u9988\u9519\u8bef\u65e5\u5fd7:{}", (Throwable)e);
        }
        return JsonResult.ok();
    }

    private JsonResult tocSettlementResult(SealedRecMessage sealedRecMessage) {
        String str = sealedRecMessage.getPayload().getObj().toString();
        SettlementResult settlementResult = (SettlementResult)JSON.parseObject((String)str, SettlementResult.class);
        if (settlementResult == null || StringUtils.isBlank((CharSequence)settlementResult.getSettlementNo())) {
            JSONObject jsonObject = JSONObject.fromObject((Object)str);
            str = jsonObject.getString("settlementResult");
            settlementResult = (SettlementResult)JSON.parseObject((String)str, SettlementResult.class);
        }
        String settlementNo = settlementResult.getSettlementNo();
        settlementNo = StringUtils.substringBeforeLast((String)settlementNo, (String)"-");
        settlementResult.setSettlementNo(settlementNo);
        return this.zySpService.settlementResultPush(settlementResult);
    }

    private String callSettlementFeedback(String str) throws Exception {
        JSONObject jsonObject = JSONObject.fromObject((Object)str);
        JSONObject settlementResult = jsonObject.getJSONObject("settlementResult");
        String settlementNo = settlementResult.get("settlementNo").toString();
        settlementResult.put((Object)"settlementNo", (Object)settlementNo.substring(settlementNo.indexOf("-") + 1));
        jsonObject.put((Object)"settlementResult", (Object)settlementResult);
        Service service = new Service();
        String url = CompanyConfig.SL_CUSTOMER_INVOICE_SERVICES + "/myws/InvoiceService.asmx?wsdl";
        String namespace = "http://www.mysoft.com.cn/FPGL/";
        String actionUri = "http://www.mysoft.com.cn/FPGL/SettlementResult";
        String op = "SettlementResult";
        Call call = (Call)service.createCall();
        call.setTargetEndpointAddress(new URL(url));
        call.setUseSOAPAction(true);
        call.setSOAPActionURI(actionUri);
        call.setOperationName(new QName(namespace, op));
        call.addParameter(new QName(namespace, "strSettlementJson"), javax.xml.rpc.encoding.XMLType.XSD_STRING, ParameterMode.IN);
        call.setReturnType(XMLType.XSD_STRING);
        Object[] params = new Object[]{jsonObject.toString()};
        String result = (String)call.invoke(params);
        return result;
    }
}

