/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.client.service.impl;

import cn.hutool.crypto.Mode;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.DES;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xforceplus.apollo.client.bean.SellerInvoice;
import com.xforceplus.apollo.client.bean.SellerInvoiceMain;
import com.xforceplus.apollo.client.bean.SettlementOrder;
import com.xforceplus.apollo.client.bean.SettlementOrderDetails;
import com.xforceplus.apollo.client.bean.SettlementResult;
import com.xforceplus.apollo.client.bean.ZySpBills;
import com.xforceplus.apollo.client.bean.ZySpInvoice;
import com.xforceplus.apollo.client.bean.ZySpRequest;
import com.xforceplus.apollo.client.bean.ZySpResponse;
import com.xforceplus.apollo.client.config.CustomerSystemConfig;
import com.xforceplus.apollo.client.service.ZySpService;
import com.xforceplus.apollo.client.service.impl.ZySpCacheUtils;
import com.xforceplus.apollo.core.domain.sellerinvoice.SellerInvoiceDetails;
import com.xforceplus.apollo.core.domain.settlement.SettlementMainParam;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.core.common.domain.JanusRequest;
import com.xforceplus.core.common.domain.JsonResult;
import com.xforceplus.core.common.utils.XHttpClientUtils;
import io.vavr.control.Either;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZySpServiceImpl
implements ZySpService {
    private static final Logger log = LoggerFactory.getLogger(ZySpServiceImpl.class);
    private static DateTimeFormatter dateTimeFormat = DateTimeFormat.forPattern((String)"yyyyMMdd");
    @Autowired
    private CustomerSystemConfig customerSystemConfig;
    @Autowired
    private XHttpClientUtils xHttpClientUtils;

    public String accessToken() {
        try {
            ZySpRequest zySpRequest = new ZySpRequest();
            zySpRequest.setUniqueKey(this.customerSystemConfig.getZySpSystem().getUKAccessToken());
            int random = ThreadLocalRandom.current().nextInt(10000000, 99999999);
            String token = this.desEncrypt(random + this.customerSystemConfig.getZySpSystem().getUserNo());
            zySpRequest.setToken(token);
            Either accessTokenEither = this.doPost(zySpRequest, null);
            if (accessTokenEither.isLeft()) {
                return null;
            }
            String accessTokenDec = this.desDecrypt(accessTokenEither.get() + "");
            log.info("accessToken \u5bc6\u6587={},\u660e\u6587={}", accessTokenEither.get(), (Object)accessTokenDec);
            return accessTokenDec;
        }
        catch (Exception e) {
            log.error("error={}", (Throwable)e);
            return null;
        }
    }

    public JanusRequest orderQuery(String posNo) {
        JanusRequest janusRequest = new JanusRequest();
        janusRequest.setIsValid(1);
        janusRequest.setValidMsg("\u81ea\u8425\u8ba2\u5355\u67e5\u8be2\u5931\u8d25\uff1a\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
        janusRequest.setData((Object)"{}");
        try {
            if (StringUtils.isBlank((CharSequence)posNo)) {
                log.info("\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002");
                janusRequest.setValidMsg("\u8ba2\u5355\u67e5\u8be2\u5931\u8d25\uff1a\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002");
                return janusRequest;
            }
            ZySpRequest zySpRequest = new ZySpRequest();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("sId", posNo);
            paramMap.put("sStoreId", "1001");
            paramMap.put("sInvoiceType", "\u7535\u5b50\u53d1\u7968");
            paramMap.put("dLimitAmount", "0");
            zySpRequest.setObjectData(paramMap);
            zySpRequest.setUniqueKey(this.customerSystemConfig.getZySpSystem().getUKOrderQuery());
            Either either = this.doPost(zySpRequest);
            if (either.isLeft()) {
                log.info("\u81ea\u8425\u8ba2\u5355\u67e5\u8be2\u5931\u8d25\uff1a:{}", either.getLeft());
                janusRequest.setValidMsg("\u81ea\u8425\u8ba2\u5355\u67e5\u8be2\u5931\u8d25\uff1a" + (String)either.getLeft());
                return janusRequest;
            }
            Either convertEither = this.convertData(either.get() + "");
            if (convertEither.isLeft()) {
                log.info("\u81ea\u8425\u8ba2\u5355\u67e5\u8be2\u5931\u8d25\uff1a:{}", convertEither.getLeft());
                janusRequest.setValidMsg("\u81ea\u8425\u8ba2\u5355\u67e5\u8be2\u5931\u8d25\uff1a" + (String)convertEither.getLeft());
                return janusRequest;
            }
            SettlementOrder settlementOrder = (SettlementOrder)convertEither.get();
            janusRequest.setIsValid(0);
            janusRequest.setData((Object)JacksonUtil.getInstance().toJson((Object)settlementOrder));
            janusRequest.setValidMsg("");
            log.info("\u76f4\u8425\u8ba2\u5355\u67e5\u8be2\u6570\u636e={}", (Object)JacksonUtil.getInstance().toJson((Object)settlementOrder));
            return janusRequest;
        }
        catch (Exception e) {
            log.error("error={}", (Throwable)e);
            return janusRequest;
        }
    }

    public JsonResult invoicePush(SellerInvoice sellerInvoice) {
        Either either = this.convertInvoice(sellerInvoice);
        if (either.isLeft()) {
            return JsonResult.error((String)((String)either.getLeft()));
        }
        ZySpInvoice zySpInvoice = (ZySpInvoice)either.get();
        ZySpRequest zySpRequest = new ZySpRequest();
        zySpRequest.setObjectData((Object)zySpInvoice);
        zySpRequest.setUniqueKey(this.customerSystemConfig.getZySpSystem().getUKInvoicePush());
        Either httpEither = this.doPost(zySpRequest);
        if (httpEither.isLeft()) {
            return JsonResult.error((String)((String)httpEither.getLeft()));
        }
        return JsonResult.ok();
    }

    public JsonResult settlementResultPush(SettlementResult settlementResult) {
        ZySpRequest zySpRequest = new ZySpRequest();
        zySpRequest.setObjectData((Object)settlementResult);
        zySpRequest.setUniqueKey(this.customerSystemConfig.getZySpSystem().getUKSettlementResultPush());
        Either httpEither = this.doPost(zySpRequest);
        if (httpEither.isLeft()) {
            return JsonResult.error((String)((String)httpEither.getLeft()));
        }
        return JsonResult.ok();
    }

    public Either<String, Object> doPost(ZySpRequest zySpRequest) {
        return this.doPost(zySpRequest, null);
    }

    public Either<String, Object> doPost(ZySpRequest zySpRequest, Map<String, String> headerMap) {
        zySpRequest.setClientTime(DateTime.now().toString());
        zySpRequest.setUserNo(this.customerSystemConfig.getZySpSystem().getUserNo());
        headerMap = Optional.ofNullable(headerMap).orElse(new HashMap());
        String url = this.customerSystemConfig.getZySpSystem().getHost();
        String body = JacksonUtil.getInstance().toJson((Object)zySpRequest);
        if (!"\u83b7\u53d6\u4ee4\u724c".equals(zySpRequest.getUniqueKey())) {
            String md5Str = ZySpCacheUtils.getAccessToken() + JacksonUtil.getInstance().toJson((Object)zySpRequest);
            md5Str = SecureUtil.md5((String)md5Str);
            log.info("Session-Key={}", (Object)md5Str);
            headerMap.put("Session-Key", md5Str);
        }
        Future jsonResultFuture = this.xHttpClientUtils.post(url, body, headerMap, null);
        try {
            JsonResult jsonResult = (JsonResult)jsonResultFuture.get(60L, TimeUnit.SECONDS);
            if (jsonResult.isFail()) {
                return Either.left((Object)jsonResult.getMessage());
            }
            String content = (String)jsonResult.getData();
            ZySpResponse zySpResponse = (ZySpResponse)JSONObject.parseObject((String)content, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            if (zySpResponse.isHasException()) {
                log.error("\u8bf7\u6c42\u81ea\u8425\u6602\u6377\u5931\u8d25:{}", (Object)zySpResponse.getException().getMessage());
                return Either.left((Object)zySpResponse.getException().getMessage());
            }
            return Either.right((Object)zySpResponse.getObjectData());
        }
        catch (Exception e) {
            log.error("error={}", (Throwable)e);
            return Either.left((Object)("\u8bf7\u6c42\u4e1a\u52a1\u7cfb\u7edf\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002" + e.getMessage()));
        }
    }

    public String desEncrypt(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        DES des = new DES(Mode.ECB, Padding.ZeroPadding, this.customerSystemConfig.getZySpSystem().getMasterKey().getBytes());
        return des.encryptBase64(content);
    }

    public String desDecrypt(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "";
        }
        DES des = new DES(Mode.ECB, Padding.ZeroPadding, this.customerSystemConfig.getZySpSystem().getMasterKey().getBytes());
        return des.decryptStr(content);
    }

    public Either<String, SettlementOrder> convertData(String content) {
        try {
            ZySpBills zySpBills = (ZySpBills)JSONObject.parseObject((String)content, ZySpBills.class);
            if (zySpBills == null || zySpBills.getBills() == null || zySpBills.getBills().size() < 1) {
                return Either.left((Object)"\u5355\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5f00\u7968\u3002");
            }
            List zySpBillsMainList = zySpBills.getBills();
            int count = Optional.ofNullable(zySpBillsMainList).orElseGet(ArrayList::new).size();
            if (count != 1) {
                return Either.left((Object)"\u8ba2\u5355\u6570\u636e\u6709\u8bef\u3002");
            }
            ZySpBills.ZySpBillsMain zySpBillsMain = (ZySpBills.ZySpBillsMain)zySpBillsMainList.get(0);
            if (zySpBillsMain.getBillDetail() == null || zySpBillsMain.getBillDetail().size() < 1) {
                return Either.left((Object)"\u8ba2\u5355\u65e0\u660e\u7ec6\u6570\u636e\u3002");
            }
            SettlementMainParam main = new SettlementMainParam();
            main.setStoreCode(zySpBillsMain.getSStoreId());
            main.setPosNo(zySpBills.getSId());
            main.setPosDate(new DateTime().toString("yyyyMMdd"));
            main.setInvoiceType("ce");
            ArrayList settlementOrderDetailsList = new ArrayList();
            List zySpBillsDetailsList = zySpBillsMain.getBillDetail();
            zySpBillsDetailsList.forEach(d -> {
                SettlementOrderDetails settlementOrderDetails = new SettlementOrderDetails();
                settlementOrderDetails.setOrderItemNo(d.getSRowType());
                settlementOrderDetails.setItemName(d.getSGname());
                settlementOrderDetails.setItemSpec(d.getSModel());
                settlementOrderDetails.setQuantityUnit(d.getSBasicUnit());
                settlementOrderDetails.setQuantity(d.getDQtty());
                settlementOrderDetails.setVolunCode(d.getSTaxCode());
                settlementOrderDetails.setItemCode(d.getSTaxCode());
                settlementOrderDetails.setTaxRate(d.getDTaxRate());
                settlementOrderDetails.setAmountWithTax(d.getDAmout());
                settlementOrderDetails.setUnitPrice(d.getDPrice());
                settlementOrderDetails.setTaxPre(d.getSIfReduct());
                settlementOrderDetails.setTaxPreCon(d.getSReductContent());
                settlementOrderDetails.setZeroTax(d.getSZeroTax());
                settlementOrderDetailsList.add(settlementOrderDetails);
            });
            if (settlementOrderDetailsList == null || settlementOrderDetailsList.size() < 1) {
                return Either.left((Object)"\u8ba2\u5355\u660e\u7ec6\u6570\u636e\u8f6c\u6362\u5931\u8d25\u3002");
            }
            BigDecimal amountWithTax = settlementOrderDetailsList.stream().map(SettlementOrderDetails::getAmountWithTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            main.setAmountWithTax(amountWithTax);
            SettlementOrder settlementOrder = new SettlementOrder();
            settlementOrder.setMain(main);
            settlementOrder.setDetails(settlementOrderDetailsList);
            return Either.right((Object)settlementOrder);
        }
        catch (Exception e) {
            log.error("error={}", (Throwable)e);
            return Either.left((Object)e.getMessage());
        }
    }

    public Either<String, ZySpInvoice> convertInvoice(SellerInvoice sellerInvoice) {
        try {
            if (sellerInvoice == null || sellerInvoice.getSellerInvoiceMain() == null || sellerInvoice.getSellerInvoiceDetails() == null) {
                return Either.left((Object)"\u6570\u636e\u4e3a\u7a7a\u6216\u89e3\u6790\u5931\u8d25.");
            }
            List sellerInvoiceDetailsList = sellerInvoice.getSellerInvoiceDetails();
            SellerInvoiceMain sellerInvoiceMain = sellerInvoice.getSellerInvoiceMain();
            String orderNo = sellerInvoiceDetailsList.stream().findFirst().map(SellerInvoiceDetails::getOrderNo).orElse("");
            ZySpInvoice zySpInvoice = new ZySpInvoice();
            zySpInvoice.setSId(orderNo);
            zySpInvoice.setSStoreId(sellerInvoiceMain.getSellerNo());
            zySpInvoice.setSBillType("\u9500\u552e\u6d41\u6c34");
            zySpInvoice.setSOperate("\u5f00\u7968");
            ZySpInvoice.Invoices zySpInvoices = new ZySpInvoice.Invoices();
            zySpInvoices.setSBillId(orderNo);
            zySpInvoices.setSBillIdThird(sellerInvoiceMain.getSellerNo());
            zySpInvoices.setSInvoiceCode(sellerInvoiceMain.getInvoiceCode());
            zySpInvoices.setSInvoiceNumber(sellerInvoiceMain.getInvoiceNo());
            if ("ce".equalsIgnoreCase(sellerInvoiceMain.getInvoiceType())) {
                zySpInvoices.setSInvoiceType("\u7535\u5b50\u53d1\u7968");
            }
            zySpInvoices.setSInvoiceUrl(sellerInvoiceMain.getPdfUrl());
            zySpInvoices.setDDt(sellerInvoiceMain.getPdfUrl());
            if (StringUtils.isNotBlank((CharSequence)sellerInvoiceMain.getPaperDrewDate())) {
                String dDt = dateTimeFormat.parseDateTime(sellerInvoiceMain.getPaperDrewDate()).toString("yyyy-MM-dd HH:mm:ss");
                zySpInvoices.setDDt(dDt);
            }
            zySpInvoice.setInvoices(Arrays.asList(zySpInvoices));
            return Either.right((Object)zySpInvoice);
        }
        catch (Exception e) {
            log.error("error={}", (Throwable)e);
            return Either.left((Object)e.getMessage());
        }
    }
}

