/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.client.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class HttpUtil {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static PoolingHttpClientConnectionManager connMgr;
    private static RequestConfig requestConfig;
    private static final int MAX_TIMEOUT = 8000;
    static final Logger logger;
    private static final String APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE_TEXT_JSON = "text/json";

    public static String doPost(String url) throws IOException {
        return HttpUtil.doPost((String)url, null);
    }

    public static String doGet(String url) throws IOException {
        return HttpUtil.doGet((String)url, null);
    }

    public static String doPost(String url, Map<String, Object> params, String cc) throws ClientProtocolException, IOException {
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        try {
            httpPost.addHeader("Content-type", "application/x-www-form-urlencoded; charset=utf-8");
            ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (ObjectUtils.isEmpty((Object)entry.getValue())) continue;
                formParams.add(new BasicNameValuePair(entry.getKey(), null == entry.getValue() ? null : entry.getValue().toString()));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams, "UTF-8"));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                String content = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                return content;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Map<String, Object> params) throws ClientProtocolException, IOException {
        String result = null;
        InputStream inStream = null;
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                if (ObjectUtils.isEmpty((Object)entry.getValue())) continue;
                formParams.add(new BasicNameValuePair(entry.getKey(), null == entry.getValue() ? null : entry.getValue().toString()));
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formParams, Consts.UTF_8);
            System.out.println(EntityUtils.toString((HttpEntity)entity));
            HttpPost httpPost = new HttpPost(url);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                result = EntityUtils.toString((HttpEntity)responseEntity);
            }
            if (httpClient != null) {
                httpClient.close();
            }
            if (response != null) {
                response.close();
            }
            String string = result;
            return string;
        }
        finally {
            if (null != inStream) {
                inStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doJsonPost(String url, String json) throws ClientProtocolException, IOException {
        String result = null;
        InputStream inStream = null;
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            StringEntity postingString = new StringEntity(json, Consts.UTF_8);
            postingString.setContentEncoding("UTF_8");
            postingString.setContentType("application/json");
            logger.info("request json = {} ", (Object)EntityUtils.toString((HttpEntity)postingString));
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)postingString);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                result = EntityUtils.toString((HttpEntity)responseEntity);
            }
            if (httpClient != null) {
                httpClient.close();
            }
            if (response != null) {
                response.close();
            }
            String string = result;
            return string;
        }
        finally {
            if (null != inStream) {
                inStream.close();
            }
        }
    }

    public static String doGet(String url, Map<String, Object> params) throws ClientProtocolException, IOException {
        HttpGet httpGet;
        CloseableHttpResponse response;
        HttpEntity entity;
        String result = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        StringBuilder urlGet = new StringBuilder(url);
        String urlParam = HttpUtil.buildQuery(params, (String)"UTF-8");
        if (!StringUtils.isEmpty((Object)urlParam)) {
            if (url.contains("?") && url.contains("=")) {
                urlGet.append("&");
            } else {
                urlGet.append("?");
            }
            urlGet.append(urlParam);
        }
        if ((entity = (response = httpClient.execute((HttpUriRequest)(httpGet = new HttpGet(urlGet.toString())))).getEntity()) != null) {
            result = EntityUtils.toString((HttpEntity)entity);
        }
        if (httpClient != null) {
            httpClient.close();
        }
        if (response != null) {
            response.close();
        }
        return result;
    }

    public static String buildQuery(Map<String, Object> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, Object>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, Object> entry : entries) {
            String value;
            String name = entry.getKey();
            String string = value = entry.getValue() == null ? null : entry.getValue().toString();
            if (StringUtils.isEmpty((Object)name)) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        String result = null;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(stream, charset));
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while ((line = in.readLine()) != null) {
                buffer.append(line);
            }
            result = buffer.toString();
        }
        finally {
            if (null != stream) {
                stream.close();
            }
            if (null != in) {
                in.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String http(String url, Map<String, String> params) {
        URL u = null;
        HttpURLConnection con = null;
        StringBuffer sb = new StringBuffer();
        if (params != null) {
            for (Map.Entry<String, String> e : params.entrySet()) {
                sb.append(e.getKey());
                sb.append("=");
                sb.append(e.getValue());
                sb.append("&");
            }
            sb.substring(0, sb.length() - 1);
        }
        try {
            u = new URL(url);
            con = (HttpURLConnection)u.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            OutputStreamWriter osw = new OutputStreamWriter(con.getOutputStream(), "UTF-8");
            osw.write(sb.toString());
            osw.flush();
            osw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        StringBuffer buffer = new StringBuffer();
        try {
            String temp;
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8"));
            while ((temp = br.readLine()) != null) {
                buffer.append(temp);
                buffer.append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doSslPostJson(String url, String json, Map<String, String> headerParam) {
        String result = null;
        InputStream instream = null;
        CloseableHttpResponse response = null;
        try {
            CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connMgr).setDefaultRequestConfig(requestConfig).build();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/json");
            if (null != headerParam) {
                for (Map.Entry<String, String> entry : headerParam.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            StringEntity se = new StringEntity(json, "UTF-8");
            se.setContentType("text/json");
            se.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json"));
            httpPost.setEntity((HttpEntity)se);
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                instream = entity.getContent();
                result = HttpUtil.getStreamAsString((InputStream)instream, (String)"UTF-8");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != instream) {
                try {
                    instream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostJson(String url, String json, Map<String, String> headerParam) {
        String result = null;
        InputStream instream = null;
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/json");
            if (null != headerParam) {
                for (Map.Entry<String, String> entry : headerParam.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            StringEntity se = new StringEntity(json, "UTF-8");
            se.setContentType("text/json");
            se.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json"));
            httpPost.setEntity((HttpEntity)se);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                instream = entity.getContent();
                result = HttpUtil.getStreamAsString((InputStream)instream, (String)"UTF-8");
            }
        }
        catch (Exception e) {
            logger.error("zeus\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (null != instream) {
                try {
                    instream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostSSL(String apiUrl, Map<String, Object> params) {
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connMgr).setDefaultRequestConfig(requestConfig).build();
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        String httpStr = null;
        try {
            BasicNameValuePair pair;
            httpPost.setConfig(requestConfig);
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>();
            if (params != null && params.size() > 0) {
                pairList = new ArrayList(params.size());
                Iterator<Map.Entry<String, Object>> iterator = params.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> entry;
                    pair = new BasicNameValuePair(entry.getKey(), null == (entry = iterator.next()).getValue() ? null : entry.getValue().toString());
                    pairList.add(pair);
                }
            }
            UrlEncodedFormEntity ttt = new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8"));
            ttt.setContentType("application/json");
            httpPost.setEntity((HttpEntity)ttt);
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                pair = null;
                return pair;
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                String string = null;
                return string;
            }
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostSSL(String apiUrl, Object json) {
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connMgr).setDefaultRequestConfig(requestConfig).build();
        HttpPost httpPost = new HttpPost(apiUrl);
        CloseableHttpResponse response = null;
        String httpStr = null;
        try {
            httpPost.setConfig(requestConfig);
            StringEntity stringEntity = new StringEntity(json.toString(), "UTF-8");
            stringEntity.setContentEncoding("UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)stringEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String string = null;
                return string;
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                String string = null;
                return string;
            }
            httpStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return httpStr;
    }

    private static SSLConnectionSocketFactory createSSLConnSocketFactory() {
        SSLConnectionSocketFactory sslsf = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new /* Unavailable Anonymous Inner Class!! */).build();
            sslsf = new SSLConnectionSocketFactory(sslContext, (X509HostnameVerifier)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        return sslsf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPostForm(String url, Map<String, String> param) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        String resultString = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            if (param != null) {
                ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
                for (String key : param.keySet()) {
                    paramList.add(new BasicNameValuePair(key, param.get(key)));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(paramList, "utf-8");
                httpPost.setEntity((HttpEntity)entity);
            }
            response = httpClient.execute((HttpUriRequest)httpPost);
            resultString = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return resultString;
    }

    static {
        logger = LoggerFactory.getLogger(HttpUtil.class);
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)HttpUtil.createSSLConnSocketFactory()).build();
        connMgr = new PoolingHttpClientConnectionManager(registry);
        connMgr.setMaxTotal(100);
        connMgr.setDefaultMaxPerRoute(connMgr.getMaxTotal());
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout(8000);
        configBuilder.setSocketTimeout(8000);
        configBuilder.setConnectionRequestTimeout(8000);
        configBuilder.setStaleConnectionCheckEnabled(true);
        requestConfig = configBuilder.build();
    }
}

