/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.client.ws.impl;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.apollo.client.CompanyConfig;
import com.xforceplus.apollo.client.bean.ApplyBillResponse;
import com.xforceplus.apollo.client.bean.JsonResult;
import com.xforceplus.apollo.client.bean.RedFlushRequest;
import com.xforceplus.apollo.client.utils.HttpUtil;
import com.xforceplus.apollo.client.ws.RedFlushRequestService;
import com.xforceplus.apollo.core.domain.applybill.ApplyBillParam;
import com.xforceplus.apollo.core.domain.applybill.OrderMainParam;
import com.xforceplus.apollo.utils.JacksonUtil;
import java.util.Arrays;
import java.util.HashMap;
import javax.jws.WebService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@WebService(serviceName="redFlushRequestService", targetNamespace="http://ws.client.apollo.xforceplus.com/", endpointInterface="com.xforceplus.apollo.client.ws.RedFlushRequestService")
@Component
public class RedFlushRequestServiceImpl
implements RedFlushRequestService {
    private static final Logger log = LoggerFactory.getLogger(RedFlushRequestServiceImpl.class);
    @Value(value="${xforceplus.janus.tocAppKey}")
    private String tocAppKey;

    public JsonResult sendRedFlush(RedFlushRequest redFlushRequest) {
        JsonResult jsonResult = JsonResult.error((String)"\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002");
        try {
            log.info("\u7ea2\u51b2\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587={}", (Object)JacksonUtil.getInstance().toJson((Object)redFlushRequest));
            if (redFlushRequest == null) {
                return jsonResult;
            }
            if (StringUtils.isBlank((CharSequence)redFlushRequest.getOriginInvoiceNo()) || StringUtils.isBlank((CharSequence)redFlushRequest.getOriginInvoiceCode())) {
                return JsonResult.error((String)"\u539f\u53d1\u7968\u53f7\u7801/\u4ee3\u7801\u5fc5\u586b\u3002");
            }
            if (StringUtils.isBlank((CharSequence)redFlushRequest.getInvoiceType()) || StringUtils.isBlank((CharSequence)redFlushRequest.getPosNo()) || StringUtils.isBlank((CharSequence)redFlushRequest.getStoreCode())) {
                return jsonResult;
            }
            redFlushRequest.setGroupFlag((String)StringUtils.defaultIfBlank((CharSequence)redFlushRequest.getGroupFlag(), (CharSequence)CompanyConfig.GROUPFLAG));
            redFlushRequest.setStatus((String)StringUtils.defaultIfBlank((CharSequence)redFlushRequest.getStatus(), (CharSequence)"1"));
            OrderMainParam orderMainParam = new OrderMainParam();
            orderMainParam.setStatus(redFlushRequest.getStatus());
            orderMainParam.setInvoiceType(redFlushRequest.getInvoiceType());
            orderMainParam.setPosNo(redFlushRequest.getPosNo());
            orderMainParam.setStoreCode(redFlushRequest.getStoreCode());
            orderMainParam.setOriginInvoiceNo(redFlushRequest.getOriginInvoiceNo());
            orderMainParam.setOriginInvoiceCode(redFlushRequest.getOriginInvoiceCode());
            orderMainParam.setGroupFlag(redFlushRequest.getGroupFlag());
            ApplyBillParam applyBillParam = new ApplyBillParam();
            applyBillParam.setGroupFlag(CompanyConfig.GROUPFLAG);
            applyBillParam.setMain(Arrays.asList(orderMainParam));
            HashMap<String, String> others = new HashMap<String, String>();
            others.put("appKey", this.tocAppKey);
            others.put("requestData", (String)applyBillParam);
            String content = JacksonUtil.getInstance().toJson(others);
            String result = HttpUtil.doJsonPost((String)(CompanyConfig.APPLY_BILL + "/api/app/applyBill"), (String)content);
            ApplyBillResponse applyBillResponse = (ApplyBillResponse)JSONObject.parseObject((String)result, ApplyBillResponse.class);
            jsonResult.setMessage(applyBillResponse.getBody());
            if (applyBillResponse.getHeader().getCode() == 0) {
                jsonResult = JsonResult.ok((String)applyBillResponse.getBody());
            }
            log.info("applyBillResponse={}", (Object)JacksonUtil.getInstance().toJson((Object)applyBillResponse));
        }
        catch (Exception e) {
            jsonResult = JsonResult.error((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
            log.error("error={}", (Throwable)e);
        }
        return jsonResult;
    }
}

