/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.client.ws.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.apollo.client.CompanyConfig;
import com.xforceplus.apollo.client.bean.SalesBillUploadBean;
import com.xforceplus.apollo.client.utils.CommonTools;
import com.xforceplus.apollo.client.utils.HttpUtil;
import com.xforceplus.apollo.client.ws.SalesBillUploadService;
import com.xforceplus.apollo.core.domain.param.SalesBillParam;
import com.xforceplus.apollo.core.domain.param.child.SalesBillChild;
import com.xforceplus.apollo.utils.JacksonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import javax.jws.WebService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@WebService(serviceName="salesBillUploadService", targetNamespace="http://ws.client.apollo.xforceplus.com/", endpointInterface="com.xforceplus.apollo.client.ws.SalesBillUploadService")
@Component
public class SalesBillUploadServiceImpl
implements SalesBillUploadService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public SalesBillUploadBean salesBillUpload(String param) {
        this.logger.warn("\u4e1a\u52a1\u5355\u4e0a\u4f20\u53c2\u6570\uff1a{}", (Object)param);
        SalesBillUploadBean salesBillUploadBean = new SalesBillUploadBean();
        salesBillUploadBean.setStatus(0);
        salesBillUploadBean.setMessage("\u6570\u636e\u4e0a\u4f20\u5931\u8d25");
        try {
            JSONObject jsonObject = JSON.parseObject((String)param);
            SalesBillChild salesBillChild = (SalesBillChild)JSON.toJavaObject((JSON)jsonObject, SalesBillChild.class);
            ArrayList<SalesBillChild> salesBillChildList = new ArrayList<SalesBillChild>();
            String billBatch = UUID.randomUUID().toString();
            salesBillChild.setSalesBillBatch(billBatch);
            salesBillChild.setSellerTenantCode(CompanyConfig.GROUPFLAG);
            String systemOrigin = CommonTools.getStr((Object)salesBillChild.getSystemOrigin());
            if (!"SY".equals(systemOrigin) && !"ZG".equals(systemOrigin)) {
                salesBillUploadBean.setMessage("\u8bf7\u586b\u5199\u7cfb\u7edf\u6765\u6e90\uff01");
                return salesBillUploadBean;
            }
            salesBillChild.setSalesBillNo(systemOrigin + "-" + salesBillChild.getSalesBillNo());
            salesBillChild.setInvoiceType(salesBillChild.getInvoiceType().toLowerCase());
            salesBillChild.setOrderNo((String)StringUtils.defaultIfBlank((CharSequence)salesBillChild.getExt24(), (CharSequence)""));
            salesBillChildList.add(salesBillChild);
            SalesBillParam salesBillParam = new SalesBillParam();
            salesBillParam.setTenantCode(CompanyConfig.GROUPFLAG);
            salesBillParam.setSalesBillUploadBatchNo(billBatch);
            salesBillParam.setSystemOrig(systemOrigin);
            salesBillParam.setStatus("1");
            salesBillParam.setSalesBillMains(salesBillChildList);
            String jsonString = JacksonUtil.getInstance().toJson((Object)salesBillParam);
            JSONObject dataJsonObject = JSON.parseObject((String)jsonString);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("appKey", CompanyConfig.APP_KEY);
            paramMap.put("requestData", (String)dataJsonObject);
            String billJson = JacksonUtil.getInstance().toJson(paramMap);
            String s = HttpUtil.doJsonPost((String)(CompanyConfig.APPLY_BILL + "/api/app/salesBillUpload"), (String)billJson);
            JSONObject json = JSON.parseObject((String)s);
            JSONObject header = json.getJSONObject("header");
            String code = header.getString("code");
            if ("0".equals(code)) {
                salesBillUploadBean.setStatus(1);
                salesBillUploadBean.setMessage("\u6570\u636e\u4e0a\u4f20\u6210\u529f");
            } else {
                salesBillUploadBean.setStatus(0);
                salesBillUploadBean.setMessage(json.getString("body"));
            }
        }
        catch (Exception e) {
            this.logger.error("[SalesBillUploadServiceImpl]-->[salesBillUpload]", (Throwable)e);
        }
        return salesBillUploadBean;
    }
}

