/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.client.ws.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.apollo.client.CompanyConfig;
import com.xforceplus.apollo.client.bean.QueryInvoiceRequest;
import com.xforceplus.apollo.client.utils.CommonTools;
import com.xforceplus.apollo.client.utils.HttpUtil;
import com.xforceplus.apollo.client.ws.SelectInvoiceService;
import com.xforceplus.apollo.utils.JacksonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import javax.jws.WebService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@WebService(serviceName="selectInvoiceService", targetNamespace="http://ws.client.apollo.xforceplus.com/", endpointInterface="com.xforceplus.apollo.client.ws.SelectInvoiceService")
@Component
public class SelectInvoiceServiceImpl
implements SelectInvoiceService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public String selectInvoice(String param) {
        this.logger.warn("\u7968\u7a0e\u52a9\u624b\u53d1\u7968\u67e5\u8be2\u53c2\u6570:{}", (Object)JacksonUtil.getInstance().toJson((Object)param));
        JSONObject restJson = new JSONObject();
        restJson.put("status", (Object)-1);
        restJson.put("msg", (Object)"\u6570\u636e\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01\uff01");
        restJson.put("result", new ArrayList());
        try {
            if (CommonTools.isEmpty((String)param)) {
                restJson.put("msg", (Object)"\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
                return JacksonUtil.getInstance().toJson((Object)restJson);
            }
            JSONObject paramJson = JSON.parseObject((String)param);
            String type = CommonTools.getStr((Object)paramJson.get((Object)"type"));
            String email = CommonTools.getStr((Object)paramJson.get((Object)"email"));
            String mobilePhone = CommonTools.getStr((Object)paramJson.get((Object)"mobilePhone"));
            if (!"1".equals(type) && !"2".equals(type)) {
                restJson.put("msg", (Object)"\u7c7b\u578b\u9519\u8bef\uff01\uff01");
                return JacksonUtil.getInstance().toJson((Object)restJson);
            }
            QueryInvoiceRequest queryInvoiceRequest = new QueryInvoiceRequest();
            queryInvoiceRequest.setSource(CompanyConfig.GROUPFLAG);
            queryInvoiceRequest.setVerifyFlag("1");
            queryInvoiceRequest.setDeleteStatus("0");
            QueryInvoiceRequest.User queryInvoiceUser = new QueryInvoiceRequest.User();
            if ("1".equals(type)) {
                queryInvoiceUser.setEmail(email);
            } else {
                queryInvoiceUser.setMobilePhone(mobilePhone);
            }
            queryInvoiceRequest.setUser(queryInvoiceUser);
            String content = JacksonUtil.getInstance().toJson((Object)queryInvoiceRequest);
            this.logger.warn("\u8bf7\u6c42\u5e73\u53f0\u53c2\u6570:{}", (Object)content);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("dataMap", content);
            String select_invoice_url = CompanyConfig.TICKET_TAXES + CompanyConfig.SELECT_INVOICE_URL;
            String resultJson = HttpUtil.doPost((String)select_invoice_url, paramMap, (String)"");
            this.logger.warn("\u8bf7\u6c42\u5e73\u53f0\u8fd4\u56de:{}", (Object)resultJson);
            JSONObject jsonObject = JSON.parseObject((String)resultJson);
            String ptStatus = CommonTools.getStr((Object)jsonObject.get((Object)"status"));
            if (!"1".equals(ptStatus)) {
                String ptMsg = CommonTools.getStr((Object)jsonObject.get((Object)"msg"));
                restJson.put("msg", (Object)ptMsg);
                return JacksonUtil.getInstance().toJson((Object)restJson);
            }
            JSONArray resutJsonArray = new JSONArray();
            JSONArray ptResultJsonArray = jsonObject.getJSONArray("result");
            if (ptResultJsonArray == null || ptResultJsonArray.isEmpty()) {
                restJson.put("msg", (Object)"\u6570\u636e\u4e3a\u7a7a\uff01");
                return JacksonUtil.getInstance().toJson((Object)restJson);
            }
            for (Object taskResult : ptResultJsonArray) {
                JSONObject _taskResult = (JSONObject)taskResult;
                JSONArray taskResArr = _taskResult.getJSONArray("invoiceRes");
                taskResArr.forEach(a -> this.getData(a, resutJsonArray));
            }
            String objectJson = JacksonUtil.getInstance().toJson((Object)resutJsonArray);
            this.logger.warn("\u7968\u7a0e\u52a9\u624b\u8f6c\u6362\u540e\u7684\u6570\u636e:{}", (Object)objectJson);
            restJson.put("status", (Object)1);
            restJson.put("msg", (Object)"success");
            restJson.put("result", (Object)resutJsonArray);
        }
        catch (Exception e) {
            this.logger.error("selectInvoice\u9519\u8bef\u65e5\u5fd7:{}", (Throwable)e);
        }
        String restStr = JacksonUtil.getInstance().toJson((Object)restJson);
        return restStr;
    }

    private void getData(Object obj, JSONArray resutJsonArray) {
        if (null == obj || !(obj instanceof JSONObject)) {
            this.logger.warn("\u6570\u636e\u89e3\u6790\u5931\u8d25.");
            return;
        }
        JSONObject resultObject = new JSONObject();
        JSONObject jsonObject = (JSONObject)obj;
        JSONObject invoiceMain = jsonObject.getJSONObject("invoiceMain");
        JSONObject purchaserInvoiceMainObject = new JSONObject();
        purchaserInvoiceMainObject.put("settlementNo", (Object)"");
        purchaserInvoiceMainObject.put("invoice", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"invoiceId")));
        purchaserInvoiceMainObject.put("isMatching", (Object)"0");
        purchaserInvoiceMainObject.put("isSource", (Object)"0");
        purchaserInvoiceMainObject.put("invoiceNo", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"invoiceNo")));
        purchaserInvoiceMainObject.put("invoiceCode", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"invoiceCode")));
        purchaserInvoiceMainObject.put("invoiceType", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"invoiceType")));
        purchaserInvoiceMainObject.put("imgUrl", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"imgUrl")));
        purchaserInvoiceMainObject.put("sellerName", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"sellerName")));
        purchaserInvoiceMainObject.put("sellerTaxNo", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"sellerTaxNo")));
        purchaserInvoiceMainObject.put("sellerAddrTel", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"sellerAddrTel")));
        purchaserInvoiceMainObject.put("sellerBankInfo", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"sellerBankInfo")));
        purchaserInvoiceMainObject.put("purchaserName", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"purchaserName")));
        purchaserInvoiceMainObject.put("purchaserTaxNo", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"purchaserTaxNo")));
        purchaserInvoiceMainObject.put("purchaserAddrTel", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"purchaserAddrTel")));
        purchaserInvoiceMainObject.put("purchaserBankInfo", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"purchaserBankInfo")));
        purchaserInvoiceMainObject.put("paperDrewDate", (Object)"");
        String paperDrewDate = CommonTools.getStr((Object)invoiceMain.get((Object)"paperDrewDate"));
        if (StringUtils.isNotBlank((CharSequence)paperDrewDate)) {
            purchaserInvoiceMainObject.put("paperDrewDate", (Object)CommonTools.DateParse((String)paperDrewDate));
        }
        purchaserInvoiceMainObject.put("taxRate", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"taxRate")));
        purchaserInvoiceMainObject.put("taxAmount", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"taxAmount")));
        purchaserInvoiceMainObject.put("amountWithoutTax", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"amountWithoutTax")));
        purchaserInvoiceMainObject.put("amountWithTax", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"amountWithTax")));
        String taxFlag = CommonTools.getStr((Object)invoiceMain.get((Object)"verifyFlag"));
        if ("1".equals(taxFlag)) {
            purchaserInvoiceMainObject.put("taxFlag", (Object)"1");
        } else if ("2".equals(taxFlag)) {
            purchaserInvoiceMainObject.put("taxFlag", (Object)"2");
        } else {
            purchaserInvoiceMainObject.put("taxFlag", (Object)"0");
        }
        purchaserInvoiceMainObject.put("authStatus", (Object)"");
        String invoiceFlag = CommonTools.getStr((Object)invoiceMain.get((Object)"invoiceFlag"));
        if ("0".equals(invoiceFlag)) {
            purchaserInvoiceMainObject.put("status", (Object)"0");
        } else {
            purchaserInvoiceMainObject.put("status", (Object)"1");
        }
        purchaserInvoiceMainObject.put("redFlag", (Object)"");
        purchaserInvoiceMainObject.put("retreatStatus", (Object)"");
        purchaserInvoiceMainObject.put("remark", (Object)CommonTools.getStr((Object)invoiceMain.get((Object)"remark")));
        JSONArray resutDetailArray = new JSONArray();
        JSONArray invoiceDetails = jsonObject.getJSONArray("invoiceDetails");
        invoiceDetails.forEach(a -> this.getDetailData(a, resutDetailArray));
        resultObject.put("purchaserInvoiceMain", (Object)purchaserInvoiceMainObject);
        resultObject.put("purchaserInvoiceDetails", (Object)resutDetailArray);
        resutJsonArray.add((Object)resultObject);
    }

    private void getDetailData(Object obj, JSONArray resutJsonArray) {
        if (null != obj && obj instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)obj;
            JSONObject purchaserInvoiceDetailObject = new JSONObject();
            purchaserInvoiceDetailObject.put("goodsTaxNo", (Object)"");
            purchaserInvoiceDetailObject.put("cargoName", (Object)CommonTools.getStr((Object)jsonObject.get((Object)"cargoName")));
            purchaserInvoiceDetailObject.put("itemSpec", (Object)CommonTools.getStr((Object)jsonObject.get((Object)"itemSpec")));
            purchaserInvoiceDetailObject.put("quantityUnit", (Object)CommonTools.getStr((Object)jsonObject.get((Object)"quantityUnit")));
            purchaserInvoiceDetailObject.put("quantity", (Object)CommonTools.getStr((Object)jsonObject.get((Object)"quantity")));
            purchaserInvoiceDetailObject.put("taxRate", (Object)CommonTools.getStr((Object)jsonObject.get((Object)"taxRate")));
            purchaserInvoiceDetailObject.put("unitPrice", (Object)CommonTools.getStr((Object)jsonObject.get((Object)"uniPrice")));
            purchaserInvoiceDetailObject.put("amountWithTax", (Object)CommonTools.getStr((Object)jsonObject.get((Object)"amountWithTax")));
            purchaserInvoiceDetailObject.put("amountWithoutTax", (Object)CommonTools.getStr((Object)jsonObject.get((Object)"amountWithoutTax")));
            purchaserInvoiceDetailObject.put("taxAmount", (Object)CommonTools.getStr((Object)jsonObject.get((Object)"taxAmount")));
            resutJsonArray.add((Object)purchaserInvoiceDetailObject);
        }
    }

    private String getToken() throws Exception {
        String accessTokenUrl = CompanyConfig.TICKET_TAXES + CompanyConfig.ACCESS_TOKEN;
        JSONObject accessJson = new JSONObject();
        accessJson.put("code", (Object)CompanyConfig.GROUPFLAG);
        accessJson.put("key", (Object)CompanyConfig.TICKET_APPKEY);
        String accessStr = HttpUtil.doJsonPost((String)accessTokenUrl, (String)accessJson.toString());
        return accessStr;
    }
}

