/*
 * Decompiled with CFR 0.152.
 */
package com.xforcecloud.excel.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.xforceplus.tenantsecurity.domain.AuthorizationInfo;
import com.xforceplus.tenantsecurity.domain.AuthorizationUri;
import com.xforceplus.tenantsecurity.utils.JsonUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ResourceUtils;

@Service
public class Json2ExcelService {
    @Value(value="${json_path:classpath:demo.json}")
    private String jsonPath;
    @Value(value="${excel_path:classpath:demo.excel}")
    private String excelPath;

    @PostConstruct
    public void process() {
        try {
            String json = FileUtils.readFileToString((File)ResourceUtils.getFile((String)this.jsonPath), (Charset)StandardCharsets.UTF_8);
            Map map = (Map)JsonUtils.fromJson((String)json, (TypeReference)new TypeReference<Map<String, AuthorizationInfo>>(){});
            XSSFWorkbook wb = new XSSFWorkbook();
            XSSFSheet sheet = wb.createSheet("a");
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                AuthorizationInfo authorizationInfo = (AuthorizationInfo)entry.getValue();
                AuthorizationUri authorizationUri = AuthorizationUri.parse((String)key);
                XSSFRow row = sheet.createRow(i);
                int j = 0;
                XSSFCell cell = row.createCell(j, CellType.STRING);
                cell.setCellValue(authorizationUri.getPath());
                cell = row.createCell(++j, CellType.STRING);
                cell.setCellValue(authorizationUri.getMethod().name());
                cell = row.createCell(++j, CellType.STRING);
                cell.setCellValue(authorizationInfo.getName());
                ++i;
            }
            FileOutputStream outputStream = new FileOutputStream("D:\\demo.xlsx");
            wb.write((OutputStream)outputStream);
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

