package com.xforceplus.action.trail.spi.api.global;

import com.xforceplus.action.trail.core.domain.MetricEvent;
import com.xforceplus.action.trail.spi.api.response.Response;
import com.xforceplus.action.trail.spi.config.FeignRetryConfiguration;
import com.xforceplus.action.trail.thread.config.GlobalThreadPoolConfig;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;


/**
 * @author duanhy
 */
@FeignClient(
        name = "action-trail-service",
        url = "${action.trail.url:action-trail-app-fat-svc.phoenix-t.xforceplus.com}"
        ,configuration = FeignRetryConfiguration.class
)
public interface ActionTrailApi {

    @Async(GlobalThreadPoolConfig.ASYNC_THREAD_POOL_EXECUTOR_TRAIL_NAME)
    @RequestMapping(
            value = {"/trail/v1/batch/save-messages-inner"},
            produces = {"application/json"},
            method = {RequestMethod.POST}
    )
    Response saveAction(@RequestBody List<MetricEvent> metricEvents);
}