package com.xforceplus.action.trail.spi.config;

import feign.RetryableException;
import feign.Retryer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static java.util.concurrent.TimeUnit.SECONDS;

/**
 * @author duanhy
 *
 * SocketException、NoHttpResponseException、UnknownHostException、HttpRetryException、
 * SocketConnectException、ConnectionClosedException 等异常都可触发Feign重试机制
 *
 */
public class FeignRetryConfiguration extends Retryer.Default {

    private static final Logger log = LoggerFactory.getLogger(FeignRetryConfiguration.class);

    public FeignRetryConfiguration() {
        //重试5次 最大间隔时间1秒
        this(100, SECONDS.toMillis(1), 5);
    }

    public FeignRetryConfiguration(long period, long maxPeriod, int maxAttempts) {
        super(period, maxPeriod, maxAttempts);
    }

    @Override
    public void continueOrPropagate(RetryableException e) {
        log.warn("【FeignRetryAble】Message【{}】", e.getMessage());
        super.continueOrPropagate(e);
    }

    @Override
    public Retryer clone() {
        return new FeignRetryConfiguration();
    }
}