package com.xforceplus.action.trail.starter.advice;

import com.xforceplus.action.trail.core.context.TrailInfoHolder;
import com.xforceplus.action.trail.core.domain.TrailInfo;
import io.geewit.web.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

/**
 * @author duanhy
 */
@Slf4j
@ControllerAdvice
@ConditionalOnProperty(prefix = "action.trail.response-body", name = "enable", havingValue = "true")
public class GlobalResponseBodyAdviceAdapter implements ResponseBodyAdvice {


    @Value("${action.trail.response-body.max.length:4096}")
    private int responseBodyMaxLength;

    @Override
    public boolean supports(MethodParameter returnType, Class converterType) {
        return true;
    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (null != body) {
            TrailInfo trailInfo = TrailInfoHolder.get();
            if (null != trailInfo) {
                try {
                    String json = JsonUtils.toJson(body);
                    if (StringUtils.isNotBlank(json) && json.length() <= responseBodyMaxLength) {
                        trailInfo.setResponseBody(json);
                        log.info(JsonUtils.toJson(trailInfo));
                    }
                } catch (Exception e) {
                    log.error("responseBody-error:{}", e.getMessage());
                }
            }
        }
        return body;
    }
}
