/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.starter.advice;

import com.xforceplus.action.trail.core.context.TrailInfoHolder;
import com.xforceplus.action.trail.core.domain.TrailInfo;
import io.geewit.web.utils.JsonUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdviceAdapter;

@ControllerAdvice
@ConditionalOnProperty(prefix="action.trail.request-body", name={"enable"}, havingValue="true")
public class GlobalRequestBodyAdviceAdapter
extends RequestBodyAdviceAdapter {
    private static final Logger log = LoggerFactory.getLogger(GlobalRequestBodyAdviceAdapter.class);
    private final HttpServletRequest httpServletRequest;
    private static final String PASSWORD = "password";
    @Value(value="${action.trail.request-body.max.length:4096}")
    private long requestBodyMaxLength;

    public GlobalRequestBodyAdviceAdapter(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return (long)this.httpServletRequest.getContentLength() < this.requestBodyMaxLength;
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        return super.beforeBodyRead(inputMessage, parameter, targetType, converterType);
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        try {
            this.logRequest(this.httpServletRequest, body);
        }
        catch (Exception exception) {
            log.error("error while logging request info:{}", (Object)exception.getMessage());
        }
        return super.afterBodyRead(body, inputMessage, parameter, targetType, converterType);
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return super.handleEmptyBody(body, inputMessage, parameter, targetType, converterType);
    }

    private void logRequest(HttpServletRequest request, Object body) {
        TrailInfo trailInfo = TrailInfoHolder.get();
        if (null == trailInfo) {
            trailInfo = new TrailInfo();
        }
        try {
            String queryString = request.getQueryString();
            if (StringUtils.isNotBlank((CharSequence)request.getQueryString())) {
                queryString = this.filterSensitiveLog(queryString);
                trailInfo.setParams(queryString);
            }
            if (body != null) {
                String requestBody = JsonUtils.toJson((Object)body);
                trailInfo.setRequestBody(requestBody);
                TrailInfoHolder.put((TrailInfo)trailInfo);
                log.info(JsonUtils.toJson((Object)trailInfo));
            }
        }
        catch (Exception e) {
            log.error("requestBody-error", (Throwable)e);
        }
    }

    private String filterSensitiveLog(String source) {
        int keyLength = 2;
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        if (!source.contains(PASSWORD)) {
            return source;
        }
        StringBuilder sb = new StringBuilder();
        String[] elements = source.split(";");
        Arrays.stream(elements).forEach(item -> {
            String[] kv = item.split("=");
            if (!kv[0].equals(PASSWORD)) {
                sb.append((String)item).append(";");
            } else {
                sb.append("pwdlength").append("=");
                if (kv.length < 2) {
                    sb.append(0).append(";");
                } else {
                    if (StringUtils.isNotBlank((CharSequence)kv[1])) {
                        sb.append(kv[1].length());
                    } else {
                        sb.append(0);
                    }
                    sb.append(";");
                }
            }
        });
        return sb.toString();
    }
}

