/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.starter.advice;

import com.xforceplus.action.trail.core.context.TrailInfoHolder;
import com.xforceplus.action.trail.core.domain.TrailInfo;
import io.geewit.web.utils.JsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
@ConditionalOnProperty(prefix="action.trail.response-body", name={"enable"}, havingValue="true")
public class GlobalResponseBodyAdviceAdapter
implements ResponseBodyAdvice {
    private static final Logger log = LoggerFactory.getLogger(GlobalResponseBodyAdviceAdapter.class);
    @Value(value="${action.trail.response-body.max.length:4096}")
    private int responseBodyMaxLength;

    public boolean supports(MethodParameter returnType, Class converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        TrailInfo trailInfo;
        if (null != body && null != (trailInfo = TrailInfoHolder.get())) {
            try {
                String json = JsonUtils.toJson((Object)body);
                if (StringUtils.isNotBlank((CharSequence)json) && json.length() <= this.responseBodyMaxLength) {
                    trailInfo.setResponseBody(json);
                    log.info(JsonUtils.toJson((Object)trailInfo));
                }
            }
            catch (Exception e) {
                log.error("responseBody-error:{}", (Object)e.getMessage());
            }
        }
        return body;
    }
}

