/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.starter.client;

import com.xforceplus.action.trail.core.domain.MetricEvent;
import com.xforceplus.action.trail.core.domain.OperationMessage;
import com.xforceplus.action.trail.core.domain.Operator;
import com.xforceplus.action.trail.core.domain.TrailInfo;
import com.xforceplus.action.trail.starter.context.SpringContextHolder;
import com.xforceplus.action.trail.starter.core.ActionTrailConsumer;
import io.geewit.web.utils.JsonUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class TrailClient {
    private static final Logger log = LoggerFactory.getLogger(TrailClient.class);

    private TrailClient() {
    }

    public static TrailClient getInstance() {
        return SingletonClassInstance.INSTANCE;
    }

    public void send(TrailInfo trailInfo, OperationMessage message) {
        Boolean actionTrailEnable = (Boolean)SpringContextHolder.getProperties((String)"action.trail.enable", (Object)false, Boolean.class);
        if (BooleanUtils.isFalse((Boolean)actionTrailEnable)) {
            log.info("action.trail.enable\u672a\u914d\u7f6e\u6216\u672a\u5f00\u542f");
            return;
        }
        this.exec(this.build(trailInfo, message));
    }

    private MetricEvent build(TrailInfo trailInfo, OperationMessage message) {
        String traceId = null;
        String url = null;
        String ip = null;
        String method = null;
        String path = null;
        String resources = null;
        String params = null;
        String requestBody = null;
        Operator operator = null;
        String clientId = null;
        if (null != trailInfo) {
            traceId = trailInfo.getEventId();
            url = trailInfo.getUri();
            ip = trailInfo.getIp();
            method = trailInfo.getHttpMethod();
            path = trailInfo.getPath();
            resources = trailInfo.getResourceCode();
            params = trailInfo.getParams();
            requestBody = trailInfo.getRequestBody();
            operator = trailInfo.getOperator();
            clientId = trailInfo.getClientId();
        }
        MetricEvent metricEvent = new MetricEvent.Builder().eventId(traceId).userInfo(operator, clientId).eventType(method).build();
        metricEvent.setRequestId(traceId);
        if (null != message) {
            metricEvent.setObjectId(message.getObjectId());
            metricEvent.setObjectOperation(message.getObjectOperation());
            metricEvent.setObjectType(message.getObjectType());
            metricEvent.setObjectOperationDetail(message.getObjectOperationDetail());
            metricEvent.setRelLeftId(message.getRelLeftId());
            metricEvent.setRelRightId(message.getRelRightId());
            metricEvent.setRelStatus(message.getRelStatus());
        }
        metricEvent.setHost(ip);
        metricEvent.setHttpMethod(method);
        metricEvent.setUri(url);
        metricEvent.setPath(path);
        metricEvent.setServiceName(SpringContextHolder.getProperties((String)"spring.application.name"));
        metricEvent.setResourceCode(resources);
        metricEvent.setParams(params);
        metricEvent.setRequestBody(requestBody);
        this.wrapEventType(metricEvent);
        return metricEvent;
    }

    private void wrapEventType(MetricEvent metricEvent) {
        metricEvent.setIsRead(Boolean.valueOf(HttpMethod.GET.name().equalsIgnoreCase(metricEvent.getHttpMethod())));
    }

    private void exec(MetricEvent metricEvent) {
        try {
            log.debug("add-trail-queue,traceId:{}", (Object)metricEvent.getRequestId());
            ActionTrailConsumer actionTrailConsumer = (ActionTrailConsumer)SpringContextHolder.getBean(ActionTrailConsumer.class);
            if (null != actionTrailConsumer) {
                actionTrailConsumer.enqueue(metricEvent);
            }
        }
        catch (Exception e) {
            log.error("saveAction error request metricEvent:{}", (Object)JsonUtils.toJson((Object)metricEvent), (Object)e);
        }
    }

    private static class SingletonClassInstance {
        private static final TrailClient INSTANCE = new TrailClient();

        private SingletonClassInstance() {
        }
    }
}

