/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.servlet.config;

import com.xforceplus.action.trail.servlet.config.ApplicationRunnerImpl;
import com.xforceplus.action.trail.servlet.interceptor.ActionTrailInterceptor;
import com.xforceplus.action.trail.spi.api.global.ActionTrailApi;
import com.xforceplus.action.trail.spi.config.FeignRetryConfiguration;
import com.xforceplus.action.trail.starter.config.ActionTrailConfig;
import com.xforceplus.action.trail.starter.config.TrailQueueConfigProps;
import com.xforceplus.action.trail.starter.context.SpringContextHolder;
import com.xforceplus.action.trail.starter.core.ActionTrailAsync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnMissingBean(value={ActionTrailConfiguration.class})
@Configuration(value="actionTrailConfiguration")
@EnableConfigurationProperties(value={TrailQueueConfigProps.class, ActionTrailConfig.class})
public class ActionTrailConfiguration
implements WebMvcConfigurer,
ApplicationContextAware,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ActionTrailConfiguration.class);
    private ApplicationContext applicationContext;

    public ActionTrailConfiguration() {
        log.info("ActionTrailConfiguration initialized");
    }

    @Bean(name={"springApplicationContextHolder"})
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder(this.applicationContext);
    }

    public ActionTrailInterceptor actionTrailInterceptor() {
        return new ActionTrailInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        log.info("registry interceptor:ActionTrailInterceptor");
        registry.addInterceptor((HandlerInterceptor)this.actionTrailInterceptor()).order(2147482657);
    }

    @Bean(name={"feignRetryConfiguration"})
    public FeignRetryConfiguration feignClientConfiguration() {
        return new FeignRetryConfiguration();
    }

    @Bean(name={"trailApplicationRunnerImpl"})
    public ApplicationRunnerImpl applicationRunnerImpl(@Autowired(required=false) ActionTrailAsync actionTrailAsync) {
        return new ApplicationRunnerImpl(actionTrailAsync);
    }

    @Bean
    public ActionTrailAsync actionTrailAsync(@Autowired(required=false) ActionTrailApi actionTrailApi, @Autowired(required=false) TrailQueueConfigProps trailQueueConfigProps) {
        return new ActionTrailAsync(actionTrailApi, trailQueueConfigProps);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void destroy() {
        SpringContextHolder.clearHolder();
    }
}

