/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.servlet.interceptor;

import com.xforceplus.action.trail.core.context.TrailInfoHolder;
import com.xforceplus.action.trail.core.domain.TrailInfo;
import com.xforceplus.action.trail.core.utils.IpUtils;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.ClientInfoHolder;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.AuthorizedUser;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.utils.uuid.UUID;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.http.HttpMethod;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class ActionTrailInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ActionTrailInterceptor.class);

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception arg3) throws Exception {
        TrailInfoHolder.clearContext();
        log.info("action.trail.infoHolder.clear...");
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView arg3) throws Exception {
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            String httpMethod = request.getMethod();
            if (httpMethod.equals(HttpMethod.POST.name()) || httpMethod.equals(HttpMethod.PUT.name()) || httpMethod.equals(HttpMethod.DELETE.name()) || httpMethod.equals(HttpMethod.PATCH.name())) {
                String traceId = request.getHeader("T_TRACE_ID");
                String url = request.getRequestURL().toString();
                log.info("url = {}, httpMethod = {}, traceId = {}", new Object[]{url, httpMethod, traceId});
                if (StringUtils.isEmpty((CharSequence)traceId)) {
                    traceId = UUID.randomUUID().toString();
                }
                String resourceCode = "";
                HandlerMethod handlerMethod = (HandlerMethod)handler;
                Method method = handlerMethod.getMethod();
                AuthorizedDefinition authorizedDefinition = method.getAnnotation(AuthorizedDefinition.class);
                if (null != authorizedDefinition) {
                    resourceCode = StringUtils.join((Object[])authorizedDefinition.resources(), (String)",");
                }
                TrailInfo trailInfo = new TrailInfo();
                trailInfo.setEventId(traceId);
                trailInfo.setIp(IpUtils.getIp((HttpServletRequest)request));
                trailInfo.setUri(url);
                trailInfo.setHttpMethod(request.getMethod());
                trailInfo.setPath(request.getRequestURI());
                trailInfo.setResourceCode(resourceCode);
                IAuthorizedUser iAuthorizedUser = UserInfoHolder.get();
                AuthorizedUser temp = new AuthorizedUser();
                if (null != iAuthorizedUser) {
                    BeanUtils.copyProperties((Object)iAuthorizedUser, (Object)temp, (String[])new String[]{"roles", "hostCompanies", "roleMaps"});
                }
                trailInfo.setAuthorizedUser((IAuthorizedUser)temp);
                trailInfo.setClientId(ClientInfoHolder.get());
                TrailInfoHolder.put((TrailInfo)trailInfo);
            }
            return true;
        }
        return handler instanceof ResourceHttpRequestHandler;
    }

    private HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
    }

    private Map<String, String> getRequestHeaderMap() {
        HttpServletRequest request = this.getRequest();
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            headerMap.put(name, request.getHeader(name));
        }
        return headerMap;
    }
}

