/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.servlet.interceptor;

import com.xforceplus.action.trail.core.context.TrailInfoHolder;
import com.xforceplus.action.trail.core.domain.Operator;
import com.xforceplus.action.trail.core.domain.TrailInfo;
import com.xforceplus.action.trail.core.utils.IpUtils;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.ClientInfoHolder;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.utils.uuid.UUID;
import io.geewit.web.utils.JsonUtils;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class ActionTrailInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ActionTrailInterceptor.class);

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception arg3) {
        TrailInfoHolder.clearContext();
        log.info("action.trail.infoHolder.clear...");
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView arg3) {
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (handler instanceof ResourceHttpRequestHandler) {
            log.debug("handler instanceof ResourceHttpRequestHandler");
            return true;
        }
        boolean isStaticPage = ActionTrailInterceptor.isStaticPage(request.getRequestURI());
        if (isStaticPage) {
            log.debug("isStaticPage: true, return");
            return true;
        }
        if (handler instanceof HandlerMethod) {
            String httpMethod = request.getMethod();
            String traceId = request.getHeader("T_TRACE_ID");
            String url = request.getRequestURL().toString();
            if (StringUtils.isEmpty((CharSequence)traceId)) {
                traceId = UUID.randomUUID().toString();
            }
            log.info("traceId = {}, url = {}, httpMethod = {}, ", new Object[]{traceId, url, httpMethod});
            response.setHeader("T_TRACE_ID", traceId);
            String resourceCode = "";
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            AuthorizedDefinition authorizedDefinition = method.getAnnotation(AuthorizedDefinition.class);
            if (null != authorizedDefinition) {
                resourceCode = StringUtils.join((Object[])authorizedDefinition.resources(), (String)",");
            }
            TrailInfo trailInfo = new TrailInfo();
            trailInfo.setEventId(traceId);
            trailInfo.setIp(IpUtils.getIp((HttpServletRequest)request));
            trailInfo.setUri(url);
            trailInfo.setHttpMethod(request.getMethod());
            trailInfo.setPath(request.getRequestURI());
            trailInfo.setResourceCode(resourceCode);
            trailInfo.setParams(request.getQueryString());
            IAuthorizedUser iAuthorizedUser = UserInfoHolder.get();
            if (null != iAuthorizedUser) {
                Operator operator = new Operator(iAuthorizedUser);
                trailInfo.setOperator(operator);
            }
            log.info("traceId = {},IAuthorizedUser = {}", (Object)traceId, (Object)JsonUtils.toJson((Object)trailInfo));
            trailInfo.setClientId(ClientInfoHolder.get());
            TrailInfoHolder.put((TrailInfo)trailInfo);
            return true;
        }
        return true;
    }

    private HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
    }

    private Map<String, String> getRequestHeaderMap() {
        HttpServletRequest request = this.getRequest();
        Enumeration headerNames = request.getHeaderNames();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            headerMap.put(name, request.getHeader(name));
        }
        return headerMap;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isStaticPage(String url) {
        suffixList = Arrays.asList(new String[]{".html", ".css", ".js", ".css", ".png", ".ttf"});
        passList = Arrays.asList(new String[]{"swagger-resources/configuration/ui", "swagger-resources", "v2/api-docs", "swagger-resources/configuration/security", "health", "xplat/health", "error"});
        if (StringUtils.isBlank((CharSequence)url)) {
            return false;
        }
        path = url.trim();
        if (StringUtils.startsWith((CharSequence)path, (CharSequence)"/")) {
            path = StringUtils.substring((String)path, (int)1);
        }
        if (suffixList.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, endsWith(java.lang.String ), (Ljava/lang/String;)Z)((String)path))) ** GOTO lbl-1000
        if (passList.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/lang/String;)Z)((String)path))) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        match = v0;
        ActionTrailInterceptor.log.debug("path=={},match=={}", (Object)url, (Object)match);
        return match;
    }
}

