/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.action.trail.servlet.config;

import com.xforceplus.action.trail.servlet.config.ApplicationRunnerImpl;
import com.xforceplus.action.trail.servlet.interceptor.ActionTrailInterceptor;
import com.xforceplus.action.trail.starter.config.ActionTrailConfig;
import com.xforceplus.action.trail.starter.config.TrailQueueConfigProps;
import com.xforceplus.action.trail.starter.context.SpringContextHolder;
import com.xforceplus.action.trail.starter.core.ActionTrailAsync;
import com.xforceplus.action.trail.starter.core.ActionTrailConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(value="actionTrailConfiguration")
@EnableConfigurationProperties(value={TrailQueueConfigProps.class, ActionTrailConfig.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnExpression(value="${action.trail.enable:false}")
public class ActionTrailConfiguration
implements WebMvcConfigurer,
ApplicationContextAware,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ActionTrailConfiguration.class);
    private ApplicationContext applicationContext;

    public ActionTrailConfiguration(TrailQueueConfigProps trailQueueConfigProps, ActionTrailConfig actionTrailConfig) {
        log.info("ActionTrailConfiguration-initialized,trailQueueConfigProps:{},actionTrailConfig:{}", (Object)trailQueueConfigProps, (Object)actionTrailConfig);
    }

    @Bean(name={"springApplicationContextHolder"})
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder(this.applicationContext);
    }

    public ActionTrailInterceptor actionTrailInterceptor() {
        return new ActionTrailInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        log.info("registry interceptor:ActionTrailInterceptor");
        registry.addInterceptor((HandlerInterceptor)this.actionTrailInterceptor()).order(2147482657);
    }

    @Bean(name={"trailApplicationRunnerImpl"})
    public ApplicationRunnerImpl applicationRunnerImpl(@Autowired(required=false) ActionTrailConsumer actionTrailConsumer) {
        return new ApplicationRunnerImpl(actionTrailConsumer);
    }

    @Bean
    public ActionTrailAsync actionTrailAsync(@Autowired(required=false) ActionTrailConfig actionTrailConfig) {
        return new ActionTrailAsync(actionTrailConfig);
    }

    @Bean
    public ActionTrailConsumer actionTrailConsumer(@Autowired(required=false) ActionTrailAsync actionTrailAsync, @Autowired(required=false) TrailQueueConfigProps trailQueueConfigProps) {
        return new ActionTrailConsumer(actionTrailAsync, trailQueueConfigProps);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void destroy() {
        SpringContextHolder.clearHolder();
    }
}

