package com.xforceplus.action.trail.servlet.config;

import com.xforceplus.action.trail.servlet.interceptor.ActionTrailInterceptor;
import com.xforceplus.action.trail.starter.config.ActionTrailConfig;
import com.xforceplus.action.trail.starter.config.TrailQueueConfigProps;
import com.xforceplus.action.trail.starter.context.SpringContextHolder;
import com.xforceplus.action.trail.starter.core.ActionTrailConsumer;
import com.xforceplus.action.trail.starter.core.ActionTrailAsync;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;



/**
 * @author duanhy
 */
@Configuration(value = "actionTrailConfiguration")
@EnableConfigurationProperties({TrailQueueConfigProps.class, ActionTrailConfig.class})
@ConditionalOnWebApplication(
        type = ConditionalOnWebApplication.Type.SERVLET
)
@ConditionalOnExpression("${action.trail.enable:false}")
@Slf4j
public class ActionTrailConfiguration implements WebMvcConfigurer, ApplicationContextAware, DisposableBean {


    public ActionTrailConfiguration(TrailQueueConfigProps trailQueueConfigProps, ActionTrailConfig actionTrailConfig) {
        log.info("ActionTrailConfiguration-initialized,trailQueueConfigProps:{},actionTrailConfig:{}", trailQueueConfigProps, actionTrailConfig);
    }

    private ApplicationContext applicationContext;

    @Bean(name = "springApplicationContextHolder")
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder(this.applicationContext);
    }

    public ActionTrailInterceptor actionTrailInterceptor() {
        return new ActionTrailInterceptor();
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        log.info("registry interceptor:ActionTrailInterceptor");
        registry.addInterceptor(actionTrailInterceptor()).order(Integer.MAX_VALUE - 990);
    }

    @Bean(name = "trailApplicationRunnerImpl")
    public ApplicationRunnerImpl applicationRunnerImpl(@Autowired(required = false) ActionTrailConsumer actionTrailConsumer) {
        return new ApplicationRunnerImpl(actionTrailConsumer);
    }


    @Bean
    public ActionTrailAsync actionTrailAsync(@Autowired(required = false) ActionTrailConfig actionTrailConfig) {
        return new ActionTrailAsync(actionTrailConfig);
    }


    @Bean
    public ActionTrailConsumer actionTrailConsumer(@Autowired(required = false) ActionTrailAsync actionTrailAsync,
                                                @Autowired(required = false) TrailQueueConfigProps trailQueueConfigProps) {
        return new ActionTrailConsumer(actionTrailAsync, trailQueueConfigProps);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void destroy() {
        SpringContextHolder.clearHolder();
    }

}
