package com.xforceplus.aliqianniu.controller;


/**
 * 商户支付订单feign客户端
 *
 * @author ultraman
 * @date 2023-10-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.aliqianniu.entity.OrderPaid;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ali-qianniu")
public interface OrderPaidFeignApi {

  /**
   * 通过id查询商户支付订单
   * @param  id
   * @return R
   */
  @GetMapping("/orderPaid/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增商户支付订单
   * @param orderPaid 商户支付订单
   * @return R
   */
  @PostMapping("/orderPaid/add")
  public R save(@RequestBody OrderPaid orderPaid);

  /**
   * 修改商户支付订单
   * @param orderPaid 商户支付订单
   * @return R
   */
  @PostMapping("/orderPaid/update")
  public R updateById(@RequestBody OrderPaid orderPaid);

  /**
   * 通过id删除商户支付订单
   * @param  id
   * @return R
   */
  @DeleteMapping("/orderPaid/del/{id}" )
  public R removeById(@PathVariable Long id);

}