package com.xforceplus.aliqianniu.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2025-10-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.aliqianniu.entity.Goods;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ali-qianniu")
public interface GoodsFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/goods/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param goods ${table.comment}
   * @return R
   */
  @PostMapping("/goods/add")
  public R save(@RequestBody Goods goods);

  /**
   * 修改${table.comment}
   * @param goods ${table.comment}
   * @return R
   */
  @PostMapping("/goods/update")
  public R updateById(@RequestBody Goods goods);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/goods/del/{id}" )
  public R removeById(@PathVariable Long id);

}