package com.xforceplus.aliqianniu.controller;


/**
 * 已开具发票feign客户端
 *
 * @author ultraman
 * @date 2025-10-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.aliqianniu.entity.ResultInvoice;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ali-qianniu")
public interface ResultInvoiceFeignApi {

  /**
   * 通过id查询已开具发票
   * @param  id
   * @return R
   */
  @GetMapping("/resultInvoice/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增已开具发票
   * @param resultInvoice 已开具发票
   * @return R
   */
  @PostMapping("/resultInvoice/add")
  public R save(@RequestBody ResultInvoice resultInvoice);

  /**
   * 修改已开具发票
   * @param resultInvoice 已开具发票
   * @return R
   */
  @PostMapping("/resultInvoice/update")
  public R updateById(@RequestBody ResultInvoice resultInvoice);

  /**
   * 通过id删除已开具发票
   * @param  id
   * @return R
   */
  @DeleteMapping("/resultInvoice/del/{id}" )
  public R removeById(@PathVariable Long id);

}