package com.xforceplus.aliqianniu.controller;


/**
 * 接口请求履历feign客户端
 *
 * @author ultraman
 * @date 2025-10-31
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.aliqianniu.entity.RequestHistory;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ali-qianniu")
public interface RequestHistoryFeignApi {

  /**
   * 通过id查询接口请求履历
   * @param  id
   * @return R
   */
  @GetMapping("/requestHistory/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增接口请求履历
   * @param requestHistory 接口请求履历
   * @return R
   */
  @PostMapping("/requestHistory/add")
  public R save(@RequestBody RequestHistory requestHistory);

  /**
   * 修改接口请求履历
   * @param requestHistory 接口请求履历
   * @return R
   */
  @PostMapping("/requestHistory/update")
  public R updateById(@RequestBody RequestHistory requestHistory);

  /**
   * 通过id删除接口请求履历
   * @param  id
   * @return R
   */
  @DeleteMapping("/requestHistory/del/{id}" )
  public R removeById(@PathVariable Long id);

}