package com.xforceplus.aliqianniu.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-04-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.aliqianniu.entity.InvoiceRules;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ali-qianniu")
public interface InvoiceRulesFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceRules/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param invoiceRules ${table.comment}
   * @return R
   */
  @PostMapping("/invoiceRules/add")
  public R save(@RequestBody InvoiceRules invoiceRules);

  /**
   * 修改${table.comment}
   * @param invoiceRules ${table.comment}
   * @return R
   */
  @PostMapping("/invoiceRules/update")
  public R updateById(@RequestBody InvoiceRules invoiceRules);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceRules/del/{id}" )
  public R removeById(@PathVariable Long id);

}