package com.xforceplus.aliqianniu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 电商代码
 * </p>
 *
 * @author ultraman
 * @since 2023-05-26
 */
public enum EcCode {

    ALI("ALI", "阿里千牛"),
    PDD("PDD", "拼多多");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    EcCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EcCode fromCode(String code){
        switch(code) {
            case "ALI":
                return ALI;
            case "PDD":
                return PDD;
            default:
                return null;
        }
    }
}
