package com.xforceplus.aliqianniu.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-06-01
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceApplyInfo implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 电商平台代码
   */
  private String platformCode;

  /**
   * 开票申请状态
   */
  private String applyStatus;

  /**
   * 买家备注
   */
  private String memo;

  /**
   * 买家抬头
   */
  private String payerName;

  /**
   * 买家税号
   */
  private String payerRegisterNo;

  /**
   * 开票申请触发类型
   */
  private String triggerStatus;

  /**
   * 发票种类（默认是0）
   */
  private String invoiceKind;

  /**
   * 抬头类型
   */
  private String businessType;

  /**
   * 颜色类型
   */
  private String colorType;

  /**
   * 开票金额
   */
  private BigDecimal invoiceAmount;

  /**
   * 不含税总金额
   */
  private BigDecimal sumPrice;

  /**
   * 总税额
   */
  private BigDecimal sumTax;

  /**
   * 购买方联系电话
   */
  private String payerPhone;

  /**
   * 购买方地址
   */
  private String payerAddress;

  /**
   * 购买方开户行账号
   */
  private String payerBankaccount;

  /**
   * 购买方开户银行
   */
  private String payerBank;

  /**
   * 发票申请修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtModifiedStr;

  /**
   * 扩展属性
   */
  private String extendProps;

  /**
   * 发票申请创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;

  /**
   * 卖家账号
   */
  private String sellerNick;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 申请处理状态
   */
  private String applyHandleStatus;

  /**
   * 错误信息
   */
  private String errorMsg;

  /**
   * 开票申请ID
   */
  private String applyId;

  /**
   * 订单号
   */
  private String platformTid;

  /**
   * 重新申请次数
   */
  private Long retryCount;

  /**
   * 可开票金额(含税)
   */
  private BigDecimal freeAmount;

  /**
   * 是否debug
   */
  private Boolean isDebug;

  /**
   * erp渠道
   */
  private String ecErpChannel;

  /**
   * 电商代码
   */
  private String ecCode;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("platform_code", platformCode);
      map.put("apply_status", applyStatus);
      map.put("memo", memo);
      map.put("payer_name", payerName);
      map.put("payer_register_no", payerRegisterNo);
      map.put("trigger_status", triggerStatus);
      map.put("invoice_kind", invoiceKind);
      map.put("business_type", businessType);
      map.put("color_type", colorType);
      map.put("invoice_amount", invoiceAmount);
      map.put("sum_price", sumPrice);
      map.put("sum_tax", sumTax);
      map.put("payer_phone", payerPhone);
      map.put("payer_address", payerAddress);
      map.put("payer_bankaccount", payerBankaccount);
      map.put("payer_bank", payerBank);
      map.put("gmt_modified_str", BocpGenUtils.toTimestamp(gmtModifiedStr));
      map.put("extend_props", extendProps);
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("seller_nick", sellerNick);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("apply_handle_status", applyHandleStatus);
      map.put("error_msg", errorMsg);
      map.put("apply_id", applyId);
      map.put("platform_tid", platformTid);
      map.put("retry_count", retryCount);
      map.put("free_amount", freeAmount);
      map.put("is_debug", isDebug);
      map.put("ec_erp_channel", ecErpChannel);
      map.put("ec_code", ecCode);
      return map;
  }

  public static InvoiceApplyInfo fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceApplyInfo entity = new InvoiceApplyInfo();
    if(map.containsKey("platform_code")) {
      Object obj = map.get("platform_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPlatformCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apply_status")) {
      Object obj = map.get("apply_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("memo")) {
      Object obj = map.get("memo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMemo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payer_name")) {
      Object obj = map.get("payer_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payer_register_no")) {
      Object obj = map.get("payer_register_no");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayerRegisterNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trigger_status")) {
      Object obj = map.get("trigger_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTriggerStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_kind")) {
      Object obj = map.get("invoice_kind");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceKind((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("color_type")) {
      Object obj = map.get("color_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setColorType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_amount")) {
      Object obj = map.get("invoice_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sum_price")) {
      Object obj = map.get("sum_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSumPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSumPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSumPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setSumPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSumPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sum_tax")) {
      Object obj = map.get("sum_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSumTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSumTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSumTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setSumTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSumTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("payer_phone")) {
      Object obj = map.get("payer_phone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayerPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payer_address")) {
      Object obj = map.get("payer_address");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payer_bankaccount")) {
      Object obj = map.get("payer_bankaccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayerBankaccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payer_bank")) {
      Object obj = map.get("payer_bank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayerBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gmt_modified_str")) {
      Object obj = map.get("gmt_modified_str");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtModifiedStr(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtModifiedStr((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setGmtModifiedStr(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtModifiedStr(null);
      }
    }
    if(map.containsKey("extend_props")) {
      Object obj = map.get("extend_props");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtendProps((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("seller_nick")) {
      Object obj = map.get("seller_nick");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerNick((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apply_handle_status")) {
      Object obj = map.get("apply_handle_status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("apply_id")) {
      Object obj = map.get("apply_id");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("platform_tid")) {
      Object obj = map.get("platform_tid");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPlatformTid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retry_count")) {
      Object obj = map.get("retry_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRetryCount((Long)obj);
        } else if(obj instanceof String) {
          entity.setRetryCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRetryCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("free_amount")) {
      Object obj = map.get("free_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFreeAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFreeAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFreeAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setFreeAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFreeAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("is_debug")) {
      Object obj = map.get("is_debug");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsDebug((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setIsDebug(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("ec_erp_channel")) {
      Object obj = map.get("ec_erp_channel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEcErpChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ec_code")) {
      Object obj = map.get("ec_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEcCode((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("platform_code")) {
      Object obj = map.get("platform_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlatformCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("apply_status")) {
      Object obj = map.get("apply_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("memo")) {
      Object obj = map.get("memo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMemo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payer_name")) {
      Object obj = map.get("payer_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payer_register_no")) {
      Object obj = map.get("payer_register_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayerRegisterNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trigger_status")) {
      Object obj = map.get("trigger_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTriggerStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_kind")) {
      Object obj = map.get("invoice_kind");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceKind((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("color_type")) {
      Object obj = map.get("color_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setColorType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_amount")) {
      Object obj = map.get("invoice_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sum_price")) {
      Object obj = map.get("sum_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSumPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSumPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSumPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setSumPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSumPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sum_tax")) {
      Object obj = map.get("sum_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSumTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSumTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSumTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setSumTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSumTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("payer_phone")) {
      Object obj = map.get("payer_phone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayerPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payer_address")) {
      Object obj = map.get("payer_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payer_bankaccount")) {
      Object obj = map.get("payer_bankaccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayerBankaccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payer_bank")) {
      Object obj = map.get("payer_bank");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayerBank((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gmt_modified_str")) {
      Object obj = map.get("gmt_modified_str");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtModifiedStr(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtModifiedStr((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setGmtModifiedStr(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtModifiedStr(null);
      }
    }
    if(map.containsKey("extend_props")) {
      Object obj = map.get("extend_props");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtendProps((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("seller_nick")) {
      Object obj = map.get("seller_nick");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerNick((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("apply_handle_status")) {
      Object obj = map.get("apply_handle_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyHandleStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("apply_id")) {
      Object obj = map.get("apply_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setApplyId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("platform_tid")) {
      Object obj = map.get("platform_tid");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlatformTid((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("retry_count")) {
      Object obj = map.get("retry_count");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRetryCount((Long)obj);
        } else if(obj instanceof String) {
          this.setRetryCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRetryCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("free_amount")) {
      Object obj = map.get("free_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setFreeAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setFreeAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setFreeAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setFreeAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setFreeAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("is_debug")) {
      Object obj = map.get("is_debug");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsDebug((Boolean)obj);
        } else if(obj instanceof String) {
          this.setIsDebug(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("ec_erp_channel")) {
      Object obj = map.get("ec_erp_channel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEcErpChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ec_code")) {
      Object obj = map.get("ec_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEcCode((String)obj);
        }
      } else {
      }
    }
  }
}
