package com.xforceplus.aliqianniu.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 阿里千牛入驻信息
 * </p>
 *
 * @author ultraman
 * @since 2023-10-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class UserTenant implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 淘宝账号
   */
  private String nick;

  /**
   * 商家租户id
   */
  private Long userTenantId;

  /**
   * 商家租户code
   */
  private String userTenantCode;

  /**
   * 公司id
   */
  private Long companyId;

  /**
   * 公司名称
   */
  private String companyName;

  /**
   * 税号
   */
  private String taxNo;

  /**
   * 手机号
   */
  private String phone;

  /**
   * 邮箱
   */
  private String email;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 是否处理中
   */
  private String isInProcess;

  /**
   * 重试次数
   */
  private Long retryCount;

  /**
   * 租户用户账号
   */
  private String tenantUserAccount;

  /**
   * 租户用户id
   */
  private Long tenantUserId;

  /**
   * 租户创建流程状态
   */
  private String processStatus;

  /**
   * 租户创建流程描述
   */
  private String processMsg;

  /**
   * 租户入驻流程是否完成
   */
  private Boolean flowFinish;

  /**
   * 入驻信息报文
   */
  private String registUrl;

  /**
   * 入驻状态
   */
  private String registStatus;

  /**
   * 入驻信息
   */
  private String registMsg;

  /**
   * 发送数量
   */
  private Long sendCount;

  /**
   * 国税类型
   */
  private String sourceType;


  /**
   * 对一关联关系 关联对象 storeInfo
   */
    private Long storeOtmQianniuId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("nick", nick);
      map.put("user_tenant_id", userTenantId);
      map.put("user_tenant_code", userTenantCode);
      map.put("company_id", companyId);
      map.put("company_name", companyName);
      map.put("tax_no", taxNo);
      map.put("phone", phone);
      map.put("email", email);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("is_in_process", isInProcess);
      map.put("retry_count", retryCount);
      map.put("tenant_user_account", tenantUserAccount);
      map.put("tenant_user_id", tenantUserId);
      map.put("process_status", processStatus);
      map.put("process_msg", processMsg);
      map.put("flow_finish", flowFinish);
      map.put("regist_url", registUrl);
      map.put("regist_status", registStatus);
      map.put("regist_msg", registMsg);
      map.put("send_count", sendCount);
      map.put("source_type", sourceType);

       map.put("storeOtmQianniu.id", storeOtmQianniuId);
      return map;
  }

  public static UserTenant fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    UserTenant entity = new UserTenant();
    if(map.containsKey("nick")) {
      Object obj = map.get("nick");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNick((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("user_tenant_id")) {
      Object obj = map.get("user_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUserTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUserTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUserTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("user_tenant_code")) {
      Object obj = map.get("user_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUserTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_id")) {
      Object obj = map.get("company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompanyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_no")) {
      Object obj = map.get("tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("phone")) {
      Object obj = map.get("phone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("email")) {
      Object obj = map.get("email");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_in_process")) {
      Object obj = map.get("is_in_process");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsInProcess((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retry_count")) {
      Object obj = map.get("retry_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRetryCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRetryCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRetryCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_user_account")) {
      Object obj = map.get("tenant_user_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantUserAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_user_id")) {
      Object obj = map.get("tenant_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("process_status")) {
      Object obj = map.get("process_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcessStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("process_msg")) {
      Object obj = map.get("process_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcessMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flow_finish")) {
      Object obj = map.get("flow_finish");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setFlowFinish((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFlowFinish(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("regist_url")) {
      Object obj = map.get("regist_url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegistUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regist_status")) {
      Object obj = map.get("regist_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegistStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regist_msg")) {
      Object obj = map.get("regist_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegistMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("send_count")) {
      Object obj = map.get("send_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSendCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSendCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSendCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("source_type")) {
      Object obj = map.get("source_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceType((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("storeOtmQianniu.id")) {
        Object obj = map.get("storeOtmQianniu.id");
      if(obj instanceof Long) {
        entity.setStoreOtmQianniuId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setStoreOtmQianniuId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("nick")) {
      Object obj = map.get("nick");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNick((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("user_tenant_id")) {
      Object obj = map.get("user_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUserTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUserTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUserTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("user_tenant_code")) {
      Object obj = map.get("user_tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUserTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_id")) {
      Object obj = map.get("company_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCompanyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCompanyId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_no")) {
      Object obj = map.get("tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("phone")) {
      Object obj = map.get("phone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("email")) {
      Object obj = map.get("email");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_in_process")) {
      Object obj = map.get("is_in_process");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsInProcess((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("retry_count")) {
      Object obj = map.get("retry_count");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRetryCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRetryCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRetryCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_user_account")) {
      Object obj = map.get("tenant_user_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantUserAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tenant_user_id")) {
      Object obj = map.get("tenant_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("process_status")) {
      Object obj = map.get("process_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcessStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("process_msg")) {
      Object obj = map.get("process_msg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcessMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("flow_finish")) {
      Object obj = map.get("flow_finish");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setFlowFinish((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFlowFinish(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("regist_url")) {
      Object obj = map.get("regist_url");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegistUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regist_status")) {
      Object obj = map.get("regist_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegistStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regist_msg")) {
      Object obj = map.get("regist_msg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegistMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("send_count")) {
      Object obj = map.get("send_count");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSendCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSendCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSendCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("source_type")) {
      Object obj = map.get("source_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSourceType((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("storeOtmQianniu.id")) {
        Object obj = map.get("storeOtmQianniu.id");
        if(obj instanceof Long) {
          this.setStoreOtmQianniuId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setStoreOtmQianniuId(Long.parseLong((String)obj));
        }
      }
  }
}
