package com.xforceplus.aliqianniu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * store_status
 * </p>
 *
 * @author ultraman
 * @since 2025-02-24
 */
public enum StoreStatus {

    _0("0", "未完成"),
    _1("1", "正常"),
    _2("2", "计费成功"),
    _3("3", "角色绑定成功"),
    _4("4", "已停用");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    StoreStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static StoreStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
