package com.xforceplus.aliqianniu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * auto_retry_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-30
 */
public enum AutoRetryStatus {

    _1("1", "正常"),
    _2("2", "完成"),
    _9("9", "终止"),
    _3("3", "执行中");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AutoRetryStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AutoRetryStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "9":
                return _9;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
