package com.xforceplus.aliqianniu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ec_erp_channel
 * </p>
 *
 * @author ultraman
 * @since 2025-11-05
 */
public enum EcErpChannel {

    SLPDD("SLPDD", "采集-拼多多"),
    QNSELLER001("qnseller001", "isv-阿里千牛"),
    YUXIAOER("yuxiaoer", "寓小二"),
    PDDRPA("PDDRPA", "RPA-拼多多"),
    YOUZAN("YOUZAN", "isv-有赞"),
    DOUYINRPA("DOUYINRPA", "RPA-抖音"),
    JDRPA("JDRPA", "RPA-京东"),
    XHSRPA("XHSRPA", "RPA-小红书"),
    CHUANGHUO("CHUANGHUO", "闯货"),
    LIAN("LIAN", "连连"),
    MEITUANWAIMAI("MEITUANWAIMAI", "外卖-美团"),
    ELEMEWAIMAI("ELEMEWAIMAI", "外卖-饿了么"),
    QUECTEL("QUECTEL", "移远通信"),
    COOPCLASS("COOPCLASS", "协同渠道测试"),
    TMYP("TMYP", "天猫优品"),
    QMAIXIAOCHENGXU("QMAIXIAOCHENGXU", "小程序-企迈"),
    JDWAIMAI("JDWAIMAI", "外卖-京东");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    EcErpChannel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EcErpChannel fromCode(String code){
        switch(code) {
            case "SLPDD":
                return SLPDD;
            case "qnseller001":
                return QNSELLER001;
            case "yuxiaoer":
                return YUXIAOER;
            case "PDDRPA":
                return PDDRPA;
            case "YOUZAN":
                return YOUZAN;
            case "DOUYINRPA":
                return DOUYINRPA;
            case "JDRPA":
                return JDRPA;
            case "XHSRPA":
                return XHSRPA;
            case "CHUANGHUO":
                return CHUANGHUO;
            case "LIAN":
                return LIAN;
            case "MEITUANWAIMAI":
                return MEITUANWAIMAI;
            case "ELEMEWAIMAI":
                return ELEMEWAIMAI;
            case "QUECTEL":
                return QUECTEL;
            case "COOPCLASS":
                return COOPCLASS;
            case "TMYP":
                return TMYP;
            case "QMAIXIAOCHENGXU":
                return QMAIXIAOCHENGXU;
            case "JDWAIMAI":
                return JDWAIMAI;
            default:
                return null;
        }
    }
}
