package com.xforceplus.aliqianniu.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * source_type
 * </p>
 *
 * @author ultraman
 * @since 2024-01-12
 */
public enum SourceType {

    SK("sk", "税控"),
    QD("qd", "全电");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SourceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SourceType fromCode(String code){
        switch(code) {
            case "sk":
                return SK;
            case "qd":
                return QD;
            default:
                return null;
        }
    }
}
