package com.xforceplus.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.aliqianniu.entity.Bill;
import com.xforceplus.aliqianniu.service.IBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-13
 */
@RestController
public class BillController {

  @Autowired
  private IBillService billServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bill ${table.comment}
   * @return
   */
  @GetMapping("/bills" )
  public XfR getBills(XfPage page, Bill bill) {
    return XfR.ok(billServiceImpl.page(page, Wrappers.query(bill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bill ${table.comment}
   * @return XfR
   */
  @PostMapping("/bills")
  public XfR save(@RequestBody Bill bill) {
     return XfR.ok(billServiceImpl.save(bill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bill ${table.comment}
   * @return XfR
   */
  @PutMapping("/bills/{id}")
  public XfR putUpdate(@RequestBody Bill bill,@PathVariable Long id) {
      bill.setId(id);
      return XfR.ok(billServiceImpl.updateById(bill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bills/{id}")
  public XfR patchUpdate(@RequestBody Bill bill,@PathVariable Long id) {
      Bill upbill = billServiceImpl.getById(id);
      if(upbill != null){
        upbill = ObjectCopyUtils.copyProperties(bill,upbill,true);
      }
      return XfR.ok(billServiceImpl.updateById(upbill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billServiceImpl.removeById(id));
  }

  @PostMapping("/bills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill");
     params.put("request", condition);

     return XfR.ok(billServiceImpl.querys(params));
  }

}
