package com.xforceplus.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.aliqianniu.entity.InvoiceTitle;
import com.xforceplus.aliqianniu.service.IInvoiceTitleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-13
 */
@RestController
public class InvoiceTitleController {

  @Autowired
  private IInvoiceTitleService invoiceTitleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceTitle ${table.comment}
   * @return
   */
  @GetMapping("/invoicetitles" )
  public XfR getInvoiceTitles(XfPage page, InvoiceTitle invoiceTitle) {
    return XfR.ok(invoiceTitleServiceImpl.page(page, Wrappers.query(invoiceTitle)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicetitles/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceTitleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceTitle ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicetitles")
  public XfR save(@RequestBody InvoiceTitle invoiceTitle) {
     return XfR.ok(invoiceTitleServiceImpl.save(invoiceTitle));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceTitle ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicetitles/{id}")
  public XfR putUpdate(@RequestBody InvoiceTitle invoiceTitle,@PathVariable Long id) {
      invoiceTitle.setId(id);
      return XfR.ok(invoiceTitleServiceImpl.updateById(invoiceTitle));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceTitle ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicetitles/{id}")
  public XfR patchUpdate(@RequestBody InvoiceTitle invoiceTitle,@PathVariable Long id) {
      InvoiceTitle upinvoiceTitle = invoiceTitleServiceImpl.getById(id);
      if(upinvoiceTitle != null){
        upinvoiceTitle = ObjectCopyUtils.copyProperties(invoiceTitle,upinvoiceTitle,true);
      }
      return XfR.ok(invoiceTitleServiceImpl.updateById(upinvoiceTitle));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicetitles/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceTitleServiceImpl.removeById(id));
  }

  @PostMapping("/invoicetitles/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_title");
     params.put("request", condition);

     return XfR.ok(invoiceTitleServiceImpl.querys(params));
  }

}
