package com.xforceplus.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.aliqianniu.entity.PdpAuthInfo;
import com.xforceplus.aliqianniu.service.IPdpAuthInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-13
 */
@RestController
public class PdpAuthInfoController {

  @Autowired
  private IPdpAuthInfoService pdpAuthInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param pdpAuthInfo ${table.comment}
   * @return
   */
  @GetMapping("/pdpauthinfos" )
  public XfR getPdpAuthInfos(XfPage page, PdpAuthInfo pdpAuthInfo) {
    return XfR.ok(pdpAuthInfoServiceImpl.page(page, Wrappers.query(pdpAuthInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/pdpauthinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(pdpAuthInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param pdpAuthInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/pdpauthinfos")
  public XfR save(@RequestBody PdpAuthInfo pdpAuthInfo) {
     return XfR.ok(pdpAuthInfoServiceImpl.save(pdpAuthInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param pdpAuthInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/pdpauthinfos/{id}")
  public XfR putUpdate(@RequestBody PdpAuthInfo pdpAuthInfo,@PathVariable Long id) {
      pdpAuthInfo.setId(id);
      return XfR.ok(pdpAuthInfoServiceImpl.updateById(pdpAuthInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param pdpAuthInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/pdpauthinfos/{id}")
  public XfR patchUpdate(@RequestBody PdpAuthInfo pdpAuthInfo,@PathVariable Long id) {
      PdpAuthInfo uppdpAuthInfo = pdpAuthInfoServiceImpl.getById(id);
      if(uppdpAuthInfo != null){
        uppdpAuthInfo = ObjectCopyUtils.copyProperties(pdpAuthInfo,uppdpAuthInfo,true);
      }
      return XfR.ok(pdpAuthInfoServiceImpl.updateById(uppdpAuthInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/pdpauthinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(pdpAuthInfoServiceImpl.removeById(id));
  }

  @PostMapping("/pdpauthinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pdp_auth_info");
     params.put("request", condition);

     return XfR.ok(pdpAuthInfoServiceImpl.querys(params));
  }

}
