package com.xforceplus.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.aliqianniu.entity.UserTenant;
import com.xforceplus.aliqianniu.service.IUserTenantService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 阿里千牛入驻信息前端控制器
 *
 * @author ultraman
 * @date 2023-12-13
 */
@RestController
public class UserTenantController {

  @Autowired
  private IUserTenantService userTenantServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param userTenant 阿里千牛入驻信息
   * @return
   */
  @GetMapping("/usertenants" )
  public XfR getUserTenants(XfPage page, UserTenant userTenant) {
    return XfR.ok(userTenantServiceImpl.page(page, Wrappers.query(userTenant)));
  }

  /**
   * 通过id查询阿里千牛入驻信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/usertenants/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(userTenantServiceImpl.getById(id));
  }

  /**
   * 新增阿里千牛入驻信息
   * @param userTenant 阿里千牛入驻信息
   * @return XfR
   */
  @PostMapping("/usertenants")
  public XfR save(@RequestBody UserTenant userTenant) {
     return XfR.ok(userTenantServiceImpl.save(userTenant));
  }

  /**
   * 修改-传入修改后的全部数据阿里千牛入驻信息
   * @param userTenant 阿里千牛入驻信息
   * @return XfR
   */
  @PutMapping("/usertenants/{id}")
  public XfR putUpdate(@RequestBody UserTenant userTenant,@PathVariable Long id) {
      userTenant.setId(id);
      return XfR.ok(userTenantServiceImpl.updateById(userTenant));
  }

  /**
   * 修改-传入修改的数据阿里千牛入驻信息
   * @param userTenant 阿里千牛入驻信息
   * @return XfR
   */
  @PatchMapping("/usertenants/{id}")
  public XfR patchUpdate(@RequestBody UserTenant userTenant,@PathVariable Long id) {
      UserTenant upuserTenant = userTenantServiceImpl.getById(id);
      if(upuserTenant != null){
        upuserTenant = ObjectCopyUtils.copyProperties(userTenant,upuserTenant,true);
      }
      return XfR.ok(userTenantServiceImpl.updateById(upuserTenant));
  }

  /**
   * 通过id删除阿里千牛入驻信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/usertenants/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(userTenantServiceImpl.removeById(id));
  }

  @PostMapping("/usertenants/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "user_tenant");
     params.put("request", condition);

     return XfR.ok(userTenantServiceImpl.querys(params));
  }

}
