package com.xforceplus.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.aliqianniu.entity.Spu;
import com.xforceplus.aliqianniu.service.ISpuService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-08
 */
@RestController
public class SpuController {

  @Autowired
  private ISpuService spuServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param spu ${table.comment}
   * @return
   */
  @GetMapping("/spus" )
  public XfR getSpus(XfPage page, Spu spu) {
    return XfR.ok(spuServiceImpl.page(page, Wrappers.query(spu)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/spus/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(spuServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param spu ${table.comment}
   * @return XfR
   */
  @PostMapping("/spus")
  public XfR save(@RequestBody Spu spu) {
     return XfR.ok(spuServiceImpl.save(spu));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param spu ${table.comment}
   * @return XfR
   */
  @PutMapping("/spus/{id}")
  public XfR putUpdate(@RequestBody Spu spu,@PathVariable Long id) {
      spu.setId(id);
      return XfR.ok(spuServiceImpl.updateById(spu));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param spu ${table.comment}
   * @return XfR
   */
  @PatchMapping("/spus/{id}")
  public XfR patchUpdate(@RequestBody Spu spu,@PathVariable Long id) {
      Spu upspu = spuServiceImpl.getById(id);
      if(upspu != null){
        upspu = ObjectCopyUtils.copyProperties(spu,upspu,true);
      }
      return XfR.ok(spuServiceImpl.updateById(upspu));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/spus/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(spuServiceImpl.removeById(id));
  }

  @PostMapping("/spus/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "spu");
     params.put("request", condition);

     return XfR.ok(spuServiceImpl.querys(params));
  }

}
