package com.xforceplus.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.aliqianniu.entity.ChannelConfig;
import com.xforceplus.aliqianniu.service.IChannelConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-04-22
 */
@RestController
public class ChannelConfigController {

  @Autowired
  private IChannelConfigService channelConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param channelConfig ${table.comment}
   * @return
   */
  @GetMapping("/channelconfigs" )
  public XfR getChannelConfigs(XfPage page, ChannelConfig channelConfig) {
    return XfR.ok(channelConfigServiceImpl.page(page, Wrappers.query(channelConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/channelconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(channelConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param channelConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/channelconfigs")
  public XfR save(@RequestBody ChannelConfig channelConfig) {
     return XfR.ok(channelConfigServiceImpl.save(channelConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param channelConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/channelconfigs/{id}")
  public XfR putUpdate(@RequestBody ChannelConfig channelConfig,@PathVariable Long id) {
      channelConfig.setId(id);
      return XfR.ok(channelConfigServiceImpl.updateById(channelConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param channelConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/channelconfigs/{id}")
  public XfR patchUpdate(@RequestBody ChannelConfig channelConfig,@PathVariable Long id) {
      ChannelConfig upchannelConfig = channelConfigServiceImpl.getById(id);
      if(upchannelConfig != null){
        upchannelConfig = ObjectCopyUtils.copyProperties(channelConfig,upchannelConfig,true);
      }
      return XfR.ok(channelConfigServiceImpl.updateById(upchannelConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/channelconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(channelConfigServiceImpl.removeById(id));
  }

  @PostMapping("/channelconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "channel_config");
     params.put("request", condition);

     return XfR.ok(channelConfigServiceImpl.querys(params));
  }

}
