package com.xforceplus.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.aliqianniu.entity.TaxNumber;
import com.xforceplus.aliqianniu.service.ITaxNumberService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-04-22
 */
@RestController
public class TaxNumberController {

  @Autowired
  private ITaxNumberService taxNumberServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param taxNumber ${table.comment}
   * @return
   */
  @GetMapping("/taxnumbers" )
  public XfR getTaxNumbers(XfPage page, TaxNumber taxNumber) {
    return XfR.ok(taxNumberServiceImpl.page(page, Wrappers.query(taxNumber)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/taxnumbers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(taxNumberServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param taxNumber ${table.comment}
   * @return XfR
   */
  @PostMapping("/taxnumbers")
  public XfR save(@RequestBody TaxNumber taxNumber) {
     return XfR.ok(taxNumberServiceImpl.save(taxNumber));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param taxNumber ${table.comment}
   * @return XfR
   */
  @PutMapping("/taxnumbers/{id}")
  public XfR putUpdate(@RequestBody TaxNumber taxNumber,@PathVariable Long id) {
      taxNumber.setId(id);
      return XfR.ok(taxNumberServiceImpl.updateById(taxNumber));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param taxNumber ${table.comment}
   * @return XfR
   */
  @PatchMapping("/taxnumbers/{id}")
  public XfR patchUpdate(@RequestBody TaxNumber taxNumber,@PathVariable Long id) {
      TaxNumber uptaxNumber = taxNumberServiceImpl.getById(id);
      if(uptaxNumber != null){
        uptaxNumber = ObjectCopyUtils.copyProperties(taxNumber,uptaxNumber,true);
      }
      return XfR.ok(taxNumberServiceImpl.updateById(uptaxNumber));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/taxnumbers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(taxNumberServiceImpl.removeById(id));
  }

  @PostMapping("/taxnumbers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tax_number");
     params.put("request", condition);

     return XfR.ok(taxNumberServiceImpl.querys(params));
  }

}
