package com.xforceplus.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.aliqianniu.entity.ReverseInvoiceApply;
import com.xforceplus.aliqianniu.service.IReverseInvoiceApplyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-17
 */
@RestController
public class ReverseInvoiceApplyController {

  @Autowired
  private IReverseInvoiceApplyService reverseInvoiceApplyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param reverseInvoiceApply ${table.comment}
   * @return
   */
  @GetMapping("/reverseinvoiceapplys" )
  public XfR getReverseInvoiceApplys(XfPage page, ReverseInvoiceApply reverseInvoiceApply) {
    return XfR.ok(reverseInvoiceApplyServiceImpl.page(page, Wrappers.query(reverseInvoiceApply)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/reverseinvoiceapplys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(reverseInvoiceApplyServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param reverseInvoiceApply ${table.comment}
   * @return XfR
   */
  @PostMapping("/reverseinvoiceapplys")
  public XfR save(@RequestBody ReverseInvoiceApply reverseInvoiceApply) {
     return XfR.ok(reverseInvoiceApplyServiceImpl.save(reverseInvoiceApply));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param reverseInvoiceApply ${table.comment}
   * @return XfR
   */
  @PutMapping("/reverseinvoiceapplys/{id}")
  public XfR putUpdate(@RequestBody ReverseInvoiceApply reverseInvoiceApply,@PathVariable Long id) {
      reverseInvoiceApply.setId(id);
      return XfR.ok(reverseInvoiceApplyServiceImpl.updateById(reverseInvoiceApply));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param reverseInvoiceApply ${table.comment}
   * @return XfR
   */
  @PatchMapping("/reverseinvoiceapplys/{id}")
  public XfR patchUpdate(@RequestBody ReverseInvoiceApply reverseInvoiceApply,@PathVariable Long id) {
      ReverseInvoiceApply upreverseInvoiceApply = reverseInvoiceApplyServiceImpl.getById(id);
      if(upreverseInvoiceApply != null){
        upreverseInvoiceApply = ObjectCopyUtils.copyProperties(reverseInvoiceApply,upreverseInvoiceApply,true);
      }
      return XfR.ok(reverseInvoiceApplyServiceImpl.updateById(upreverseInvoiceApply));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/reverseinvoiceapplys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(reverseInvoiceApplyServiceImpl.removeById(id));
  }

  @PostMapping("/reverseinvoiceapplys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "reverse_invoice_apply");
     params.put("request", condition);

     return XfR.ok(reverseInvoiceApplyServiceImpl.querys(params));
  }

}
