package com.xforceplus.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.aliqianniu.entity.InvoiceRules;
import com.xforceplus.aliqianniu.service.IInvoiceRulesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-21
 */
@RestController
public class InvoiceRulesController {

  @Autowired
  private IInvoiceRulesService invoiceRulesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceRules ${table.comment}
   * @return
   */
  @GetMapping("/invoiceruless" )
  public XfR getInvoiceRuless(XfPage page, InvoiceRules invoiceRules) {
    return XfR.ok(invoiceRulesServiceImpl.page(page, Wrappers.query(invoiceRules)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceruless/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceRulesServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceRules ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoiceruless")
  public XfR save(@RequestBody InvoiceRules invoiceRules) {
     return XfR.ok(invoiceRulesServiceImpl.save(invoiceRules));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceRules ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoiceruless/{id}")
  public XfR putUpdate(@RequestBody InvoiceRules invoiceRules,@PathVariable Long id) {
      invoiceRules.setId(id);
      return XfR.ok(invoiceRulesServiceImpl.updateById(invoiceRules));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceRules ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoiceruless/{id}")
  public XfR patchUpdate(@RequestBody InvoiceRules invoiceRules,@PathVariable Long id) {
      InvoiceRules upinvoiceRules = invoiceRulesServiceImpl.getById(id);
      if(upinvoiceRules != null){
        upinvoiceRules = ObjectCopyUtils.copyProperties(invoiceRules,upinvoiceRules,true);
      }
      return XfR.ok(invoiceRulesServiceImpl.updateById(upinvoiceRules));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceruless/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceRulesServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceruless/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_rules");
     params.put("request", condition);

     return XfR.ok(invoiceRulesServiceImpl.querys(params));
  }

}
