package com.xforceplus.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.aliqianniu.entity.RequestHistory;
import com.xforceplus.aliqianniu.service.IRequestHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 接口请求履历前端控制器
 *
 * @author ultraman
 * @date 2025-10-21
 */
@RestController
public class RequestHistoryController {

  @Autowired
  private IRequestHistoryService requestHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param requestHistory 接口请求履历
   * @return
   */
  @GetMapping("/requesthistorys" )
  public XfR getRequestHistorys(XfPage page, RequestHistory requestHistory) {
    return XfR.ok(requestHistoryServiceImpl.page(page, Wrappers.query(requestHistory)));
  }

  /**
   * 通过id查询接口请求履历
   * @param  id
   * @return XfR
   */
  @GetMapping("/requesthistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(requestHistoryServiceImpl.getById(id));
  }

  /**
   * 新增接口请求履历
   * @param requestHistory 接口请求履历
   * @return XfR
   */
  @PostMapping("/requesthistorys")
  public XfR save(@RequestBody RequestHistory requestHistory) {
     return XfR.ok(requestHistoryServiceImpl.save(requestHistory));
  }

  /**
   * 修改-传入修改后的全部数据接口请求履历
   * @param requestHistory 接口请求履历
   * @return XfR
   */
  @PutMapping("/requesthistorys/{id}")
  public XfR putUpdate(@RequestBody RequestHistory requestHistory,@PathVariable Long id) {
      requestHistory.setId(id);
      return XfR.ok(requestHistoryServiceImpl.updateById(requestHistory));
  }

  /**
   * 修改-传入修改的数据接口请求履历
   * @param requestHistory 接口请求履历
   * @return XfR
   */
  @PatchMapping("/requesthistorys/{id}")
  public XfR patchUpdate(@RequestBody RequestHistory requestHistory,@PathVariable Long id) {
      RequestHistory uprequestHistory = requestHistoryServiceImpl.getById(id);
      if(uprequestHistory != null){
        uprequestHistory = ObjectCopyUtils.copyProperties(requestHistory,uprequestHistory,true);
      }
      return XfR.ok(requestHistoryServiceImpl.updateById(uprequestHistory));
  }

  /**
   * 通过id删除接口请求履历
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/requesthistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(requestHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/requesthistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "request_history");
     params.put("request", condition);

     return XfR.ok(requestHistoryServiceImpl.querys(params));
  }

}
