package com.xforceplus.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.aliqianniu.entity.ChannelBrand;
import com.xforceplus.aliqianniu.service.IChannelBrandService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-22
 */
@RestController
public class ChannelBrandController {

  @Autowired
  private IChannelBrandService channelBrandServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param channelBrand ${table.comment}
   * @return
   */
  @GetMapping("/channelbrands" )
  public XfR getChannelBrands(XfPage page, ChannelBrand channelBrand) {
    return XfR.ok(channelBrandServiceImpl.page(page, Wrappers.query(channelBrand)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/channelbrands/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(channelBrandServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param channelBrand ${table.comment}
   * @return XfR
   */
  @PostMapping("/channelbrands")
  public XfR save(@RequestBody ChannelBrand channelBrand) {
     return XfR.ok(channelBrandServiceImpl.save(channelBrand));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param channelBrand ${table.comment}
   * @return XfR
   */
  @PutMapping("/channelbrands/{id}")
  public XfR putUpdate(@RequestBody ChannelBrand channelBrand,@PathVariable Long id) {
      channelBrand.setId(id);
      return XfR.ok(channelBrandServiceImpl.updateById(channelBrand));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param channelBrand ${table.comment}
   * @return XfR
   */
  @PatchMapping("/channelbrands/{id}")
  public XfR patchUpdate(@RequestBody ChannelBrand channelBrand,@PathVariable Long id) {
      ChannelBrand upchannelBrand = channelBrandServiceImpl.getById(id);
      if(upchannelBrand != null){
        upchannelBrand = ObjectCopyUtils.copyProperties(channelBrand,upchannelBrand,true);
      }
      return XfR.ok(channelBrandServiceImpl.updateById(upchannelBrand));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/channelbrands/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(channelBrandServiceImpl.removeById(id));
  }

  @PostMapping("/channelbrands/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "channel_brand");
     params.put("request", condition);

     return XfR.ok(channelBrandServiceImpl.querys(params));
  }

}
