package com.xforceplus.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.aliqianniu.entity.Coupon;
import com.xforceplus.aliqianniu.service.ICouponService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-30
 */
@RestController
public class CouponController {

  @Autowired
  private ICouponService couponServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param coupon ${table.comment}
   * @return
   */
  @GetMapping("/coupons" )
  public XfR getCoupons(XfPage page, Coupon coupon) {
    return XfR.ok(couponServiceImpl.page(page, Wrappers.query(coupon)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/coupons/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(couponServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param coupon ${table.comment}
   * @return XfR
   */
  @PostMapping("/coupons")
  public XfR save(@RequestBody Coupon coupon) {
     return XfR.ok(couponServiceImpl.save(coupon));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param coupon ${table.comment}
   * @return XfR
   */
  @PutMapping("/coupons/{id}")
  public XfR putUpdate(@RequestBody Coupon coupon,@PathVariable Long id) {
      coupon.setId(id);
      return XfR.ok(couponServiceImpl.updateById(coupon));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param coupon ${table.comment}
   * @return XfR
   */
  @PatchMapping("/coupons/{id}")
  public XfR patchUpdate(@RequestBody Coupon coupon,@PathVariable Long id) {
      Coupon upcoupon = couponServiceImpl.getById(id);
      if(upcoupon != null){
        upcoupon = ObjectCopyUtils.copyProperties(coupon,upcoupon,true);
      }
      return XfR.ok(couponServiceImpl.updateById(upcoupon));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/coupons/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(couponServiceImpl.removeById(id));
  }

  @PostMapping("/coupons/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "coupon");
     params.put("request", condition);

     return XfR.ok(couponServiceImpl.querys(params));
  }

}
