package com.xforceplus.aliqianniu.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.aliqianniu.entity.UserAuth;
import com.xforceplus.aliqianniu.service.IUserAuthService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 用户授权前端控制器
 *
 * @author ultraman
 * @date 2025-10-31
 */
@RestController
public class UserAuthController {

  @Autowired
  private IUserAuthService userAuthServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param userAuth 用户授权
   * @return
   */
  @GetMapping("/userauths" )
  public XfR getUserAuths(XfPage page, UserAuth userAuth) {
    return XfR.ok(userAuthServiceImpl.page(page, Wrappers.query(userAuth)));
  }

  /**
   * 通过id查询用户授权
   * @param  id
   * @return XfR
   */
  @GetMapping("/userauths/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(userAuthServiceImpl.getById(id));
  }

  /**
   * 新增用户授权
   * @param userAuth 用户授权
   * @return XfR
   */
  @PostMapping("/userauths")
  public XfR save(@RequestBody UserAuth userAuth) {
     return XfR.ok(userAuthServiceImpl.save(userAuth));
  }

  /**
   * 修改-传入修改后的全部数据用户授权
   * @param userAuth 用户授权
   * @return XfR
   */
  @PutMapping("/userauths/{id}")
  public XfR putUpdate(@RequestBody UserAuth userAuth,@PathVariable Long id) {
      userAuth.setId(id);
      return XfR.ok(userAuthServiceImpl.updateById(userAuth));
  }

  /**
   * 修改-传入修改的数据用户授权
   * @param userAuth 用户授权
   * @return XfR
   */
  @PatchMapping("/userauths/{id}")
  public XfR patchUpdate(@RequestBody UserAuth userAuth,@PathVariable Long id) {
      UserAuth upuserAuth = userAuthServiceImpl.getById(id);
      if(upuserAuth != null){
        upuserAuth = ObjectCopyUtils.copyProperties(userAuth,upuserAuth,true);
      }
      return XfR.ok(userAuthServiceImpl.updateById(upuserAuth));
  }

  /**
   * 通过id删除用户授权
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/userauths/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(userAuthServiceImpl.removeById(id));
  }

  @PostMapping("/userauths/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "user_auth");
     params.put("request", condition);

     return XfR.ok(userAuthServiceImpl.querys(params));
  }

}
