/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.janus.standalone.sdk.beans;

import com.xforceplus.apollo.janus.standalone.sdk.annotation.SQSListener;
import com.xforceplus.apollo.janus.standalone.sdk.config.JanusStandaloneAssit;
import com.xforceplus.xplat.aws.common.AwsHelper;
import com.xforceplus.xplat.aws.sqs.SqsService;
import com.xforceplus.xplat.aws.sqs.listener.AbsSQSListener;
import com.xforceplus.xplat.aws.sqs.singleton.SqsClientSingleton;
import java.util.Map;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SQSListenerBean<T>
implements InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SQSListenerBean.class);
    private SQSListener service;
    private ApplicationContext applicationContext;
    private T ref;

    public SQSListenerBean(SQSListener service) {
        this.service = service;
    }

    public T getRef() {
        return this.ref;
    }

    public void setRef(T ref) {
        this.ref = ref;
    }

    public void afterPropertiesSet() throws Exception {
        SqsService sqs = null;
        try {
            sqs = (SqsService)this.applicationContext.getBean(SqsService.class);
        }
        catch (Exception e) {
            sqs = SqsClientSingleton.getInst().getSqs();
        }
        String inputQueueName = this.service.queueName();
        int begin = inputQueueName.indexOf("${");
        if (begin >= 0) {
            int end = inputQueueName.indexOf("}");
            String key = StringUtil.trimSpace((String)inputQueueName.substring(begin + 2, end));
            Map<String, String> findAllProps = ((JanusStandaloneAssit)this.applicationContext.getBean(JanusStandaloneAssit.class)).findAllProps();
            if (!findAllProps.containsKey(key)) {
                throw new RuntimeException("\u65e0\u6cd5\u542f\u52a8\u76d1\u542c\uff0c\u627e\u4e0d\u5230\u53d8\u91cf:" + key);
            }
            inputQueueName = findAllProps.get(key);
        }
        String queueName = this.service.prefix() ? AwsHelper.buildQueueName((String)inputQueueName) : inputQueueName;
        int maxNumberOfMessages = this.service.maxNumberOfMessages();
        if (maxNumberOfMessages <= 0) {
            maxNumberOfMessages = "default".equals(this.service.namespace()) ? Conf.getInt((String)"xplat.aws.sqs.receiver.maxNumberOfMessages") : Conf.getInt((String)"xplat.aws.sqs.receiver.pool.maxNumberOfMessages");
        }
        if (this.service.attributeAll()) {
            sqs.queueReceiverListener(queueName, this.service.namespace(), (AbsSQSListener)this.ref, maxNumberOfMessages, 0, new String[]{".*"});
        } else {
            sqs.queueReceiverListener(queueName, this.service.namespace(), (AbsSQSListener)this.ref, maxNumberOfMessages, 0, this.service.attributeNames());
        }
        log.info("the top:{} has listening", (Object)queueName);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

